/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TransactionIsolationTest")
public class TransactionIsolationTest
extends MultipleCacheManagersTest {
    private static final Person RADIM = new Person("Radim", "So young!", 29);
    private static final Person TRISTAN = new Person("Tristan", "Too old.", 44);

    public Object[] factory() {
        return new Object[]{new TransactionIsolationTest().lockingMode(LockingMode.PESSIMISTIC), new TransactionIsolationTest().lockingMode(LockingMode.OPTIMISTIC)};
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TransactionIsolationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        builder.transaction().lockingMode(this.lockingMode);
        builder.indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("hibernate.search.default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, builder);
    }

    public void testDuringTransactionPrimary() throws Exception {
        this.testDuringTransaction(this.getStringKeyForCache(this.cache(0)));
    }

    public void testDuringTransactionBackup() throws Exception {
        this.testDuringTransaction(this.getStringKeyForCache(this.cache(1)));
    }

    private void testDuringTransaction(String key) throws Exception {
        this.cache(0).put((Object)key, (Object)RADIM);
        QueryFactory qf0 = Search.getQueryFactory((Cache)this.cache(0));
        AssertJUnit.assertEquals(Collections.singletonList(RADIM), this.getYoungerThan(qf0, 30));
        TestingUtil.withTx((TransactionManager)this.tm(0), () -> {
            this.cache(0).put((Object)key, (Object)TRISTAN);
            Transaction suspended = this.tm(0).suspend();
            AssertJUnit.assertEquals(Collections.singletonList(RADIM), this.getYoungerThan(qf0, 30));
            this.tm(0).resume(suspended);
            return null;
        });
        AssertJUnit.assertEquals(Collections.emptyList(), this.getYoungerThan(qf0, 30));
        AssertJUnit.assertEquals(Collections.singletonList(TRISTAN), this.getYoungerThan(qf0, 100));
    }

    public void testPrepareFailurePrimary() throws Exception {
        this.testPrepareFailure(this.getStringKeyForCache(this.cache(0)));
    }

    public void testPrepareFailureBackup() throws Exception {
        this.testPrepareFailure(this.getStringKeyForCache(this.cache(1)));
    }

    private void testPrepareFailure(String key) throws Exception {
        this.cache(0).put((Object)key, (Object)RADIM);
        QueryFactory qf0 = Search.getQueryFactory((Cache)this.cache(0));
        AssertJUnit.assertEquals(Collections.singletonList(RADIM), this.getYoungerThan(qf0, 30));
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)new FailPrepare(), 0);
        this.tm(0).begin();
        this.cache(0).put((Object)key, (Object)TRISTAN);
        try {
            this.tm(0).commit();
            AssertJUnit.fail((String)"Should rollback");
        }
        catch (Throwable t) {
            if (t instanceof CacheException) {
                t = t.getCause();
            }
            Exceptions.assertException(RollbackException.class, (Throwable)t);
        }
        Person expected = this.lockingMode == LockingMode.OPTIMISTIC ? RADIM : TRISTAN;
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache(0).get((Object)key));
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache(1).get((Object)key));
        List<Object> expectedResult = this.lockingMode == LockingMode.OPTIMISTIC ? Collections.singletonList(RADIM) : Collections.emptyList();
        AssertJUnit.assertEquals(expectedResult, this.getYoungerThan(qf0, 30));
    }

    @AfterMethod
    public void dropFailPrepare() {
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().removeInterceptor(FailPrepare.class);
    }

    private List<Object> getYoungerThan(QueryFactory queryFactory, int age) {
        String q = String.format("FROM %s where age:[* to %s]", Person.class.getName(), age);
        return queryFactory.create(q).execute().list();
    }

    private String getStringKeyForCache(Cache cache) {
        LocalizedCacheTopology topology = cache.getAdvancedCache().getDistributionManager().getCacheTopology();
        return IntStream.generate(ThreadLocalRandom.current()::nextInt).mapToObj(i -> "key" + i).filter(key -> topology.getDistribution(key).isPrimary()).findAny().get();
    }

    static class FailPrepare
    extends DDAsyncInterceptor {
        FailPrepare() {
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.invokeNextThenApply((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
                throw new TestException("Induced!");
            });
        }
    }
}

