/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.RowMatcher;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.objectfilter.impl.syntax.FullTextVisitor;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.SyntaxTreePrinter;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.RowPropertyHelper;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.ClusteredCacheQueryImpl;
import org.infinispan.query.core.impl.AggregatingQuery;
import org.infinispan.query.core.impl.EmbeddedQuery;
import org.infinispan.query.core.impl.EmptyResultQuery;
import org.infinispan.query.core.impl.HybridQuery;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.HsQueryRequest;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryMaker;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryParsingResult;
import org.infinispan.query.dsl.embedded.impl.ObjectReflectionMatcher;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.CacheQueryImpl;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.SearchManagerImpl;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.SearchManagerImplementor;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;

public class QueryEngine<TypeMetadata>
extends org.infinispan.query.core.impl.QueryEngine<TypeMetadata> {
    private static final Log log = (Log)LogFactory.getLog(QueryEngine.class, Log.class);
    private static final int MAX_EXPANSION_COFACTORS = 16;
    protected final boolean isIndexed;
    private final LuceneQueryMaker.FieldBridgeAndAnalyzerProvider<TypeMetadata> fieldBridgeAndAnalyzerProvider;
    private SearchManagerImplementor searchManager;
    private SearchIntegrator searchFactory;
    private static final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider = (SerializableFunction & Serializable)c -> (QueryEngine)((Object)((Object)c.getComponentRegistry().getComponent(QueryEngine.class)));

    public QueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed) {
        this(cache, isIndexed, ObjectReflectionMatcher.class, null);
    }

    protected QueryEngine(AdvancedCache<?, ?> cache, boolean isIndexed, Class<? extends Matcher> matcherImplClass, LuceneQueryMaker.FieldBridgeAndAnalyzerProvider<TypeMetadata> fieldBridgeAndAnalyzerProvider) {
        super(cache, matcherImplClass);
        this.isIndexed = isIndexed;
        this.fieldBridgeAndAnalyzerProvider = fieldBridgeAndAnalyzerProvider == null && this.propertyHelper instanceof HibernateSearchPropertyHelper ? ((HibernateSearchPropertyHelper)this.propertyHelper).getDefaultFieldBridgeProvider() : fieldBridgeAndAnalyzerProvider;
    }

    protected SearchManagerImplementor getSearchManager() {
        if (!this.isIndexed) {
            throw new IllegalStateException("Cache is not indexed");
        }
        if (this.searchManager == null) {
            this.searchManager = new SearchManagerImpl(this.cache, this);
        }
        return this.searchManager;
    }

    protected SearchIntegrator getSearchFactory() {
        if (this.searchFactory == null) {
            this.searchFactory = ComponentRegistryUtils.getSearchIntegrator(this.cache);
        }
        return this.searchFactory;
    }

    public Class<? extends Matcher> getMatcherClass() {
        return this.matcherImplClass;
    }

    ObjectPropertyHelper<TypeMetadata> getPropertyHelper() {
        return this.propertyHelper;
    }

    BaseQuery<?> buildQuery(QueryFactory queryFactory, IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        return this.buildQuery(queryFactory, parsingResult, namedParameters, startOffset, maxResults, IndexedQueryMode.FETCH);
    }

    protected BaseQuery<?> buildQueryWithAggregations(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, IndexedQueryMode queryMode) {
        int idx;
        Class propertyType;
        if (parsingResult.getProjectedPaths() == null) {
            throw Log.CONTAINER.groupingAndAggregationQueriesMustUseProjections();
        }
        LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns = new LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata>();
        if (parsingResult.getGroupBy() != null) {
            for (PropertyPath p : parsingResult.getGroupBy()) {
                if (p instanceof AggregationPropertyPath) {
                    throw Log.CONTAINER.cannotHaveAggregationsInGroupByClause();
                }
                if (columns.containsKey(p)) continue;
                if (this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) {
                    throw Log.CONTAINER.multivaluedPropertyCannotBeUsedInGroupBy(p.toString());
                }
                propertyType = this.propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityMetadata(), p.asArrayPath());
                idx = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
            }
        }
        int noOfGroupingColumns = columns.size();
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (!(p instanceof AggregationPropertyPath || c != null && c.getColumnIndex() < noOfGroupingColumns)) {
                throw Log.CONTAINER.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
            }
            if (c != null) continue;
            propertyType = FieldAccumulator.getOutputType((AggregationFunction)((AggregationPropertyPath)p).getAggregationFunction(), (Class)parsingResult.getProjectedTypes()[i]);
            idx = columns.size();
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (!(p instanceof AggregationPropertyPath || c != null && c.getColumnIndex() < noOfGroupingColumns)) {
                    throw Log.CONTAINER.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
                }
                if (c != null) continue;
                Class propertyType2 = this.propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityMetadata(), p.asArrayPath());
                int idx2 = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx2, "C" + idx2, propertyType2));
            }
        }
        String havingClause = null;
        if (parsingResult.getHavingClause() != null) {
            BooleanExpr normalizedHavingClause = booleanFilterNormalizer.normalize(parsingResult.getHavingClause());
            if (normalizedHavingClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, queryString, namedParameters, startOffset, maxResults);
            }
            if (normalizedHavingClause != ConstantBooleanExpr.TRUE) {
                havingClause = SyntaxTreePrinter.printTree((BooleanExpr)this.swapVariables(normalizedHavingClause, parsingResult.getTargetEntityMetadata(), columns, namedParameters, this.propertyHelper));
            }
        }
        for (PropertyPath p : columns.keySet()) {
            if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
            return this.buildQueryWithRepeatedAggregations(queryFactory, queryString, namedParameters, startOffset, maxResults, parsingResult, havingClause, columns, noOfGroupingColumns, queryMode);
        }
        LinkedHashMap<String, Integer> inColumns = new LinkedHashMap<String, Integer>();
        LinkedList<FieldAccumulator> accumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            _columns[c.getColumnIndex()] = c;
            String asStringPath = p.asStringPath();
            Integer inIdx = (Integer)inColumns.get(asStringPath);
            if (inIdx == null) {
                inIdx = inColumns.size();
                inColumns.put(asStringPath, inIdx);
            }
            if (!(p instanceof AggregationPropertyPath)) continue;
            FieldAccumulator acc = FieldAccumulator.makeAccumulator((AggregationFunction)((AggregationPropertyPath)p).getAggregationFunction(), (int)inIdx, (int)c.getColumnIndex(), (Class)c.getPropertyType());
            accumulators.add(acc);
        }
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("SELECT ");
        boolean isFirst = true;
        for (String p : inColumns.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                firstPhaseQuery.append(", ");
            }
            firstPhaseQuery.append("_gen0").append('.').append(p);
        }
        firstPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, queryString, namedParameters, startOffset, maxResults);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(SyntaxTreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                secondPhaseQuery.append(", ");
            }
            secondPhaseQuery.append(c.getColumnName());
        }
        secondPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            secondPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            secondPhaseQuery.append(" ORDER BY ");
            boolean isFirst2 = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst2) {
                    isFirst2 = false;
                } else {
                    secondPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                secondPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery<?> baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr), queryMode);
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, secondPhaseQueryStr, namedParameters, noOfGroupingColumns, accumulators, false, this.getObjectFilter((Matcher)new RowMatcher(_columns), secondPhaseQueryStr, namedParameters, null), startOffset, maxResults, baseQuery);
    }

    private BooleanExpr swapVariables(BooleanExpr expr, final TypeMetadata targetEntityMetadata, final LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, final Map<String, Object> namedParameters, final ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        class PropertyReplacer
        extends ExprVisitor {
            PropertyReplacer() {
            }

            public BooleanExpr visit(NotExpr notExpr) {
                return new NotExpr((BooleanExpr)notExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(OrExpr orExpr) {
                ArrayList<BooleanExpr> visitedChildren = new ArrayList<BooleanExpr>();
                for (BooleanExpr c : orExpr.getChildren()) {
                    visitedChildren.add((BooleanExpr)c.acceptVisitor((Visitor)this));
                }
                return new OrExpr(visitedChildren);
            }

            public BooleanExpr visit(AndExpr andExpr) {
                ArrayList<BooleanExpr> visitedChildren = new ArrayList<BooleanExpr>();
                for (BooleanExpr c : andExpr.getChildren()) {
                    visitedChildren.add((BooleanExpr)c.acceptVisitor((Visitor)this));
                }
                return new AndExpr(visitedChildren);
            }

            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            public BooleanExpr visit(IsNullExpr isNullExpr) {
                return new IsNullExpr((ValueExpr)isNullExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                return new ComparisonExpr((ValueExpr)comparisonExpr.getLeftChild().acceptVisitor((Visitor)this), comparisonExpr.getRightChild(), comparisonExpr.getComparisonType());
            }

            public BooleanExpr visit(LikeExpr likeExpr) {
                return new LikeExpr((ValueExpr)likeExpr.getChild().acceptVisitor((Visitor)this), (Object)likeExpr.getPattern(namedParameters));
            }

            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(propertyValueExpr.getPropertyPath());
                if (c == null) {
                    throw Log.CONTAINER.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(propertyValueExpr.toQueryString());
                }
                return new PropertyValueExpr(c.getColumnName(), propertyValueExpr.isRepeated(), propertyValueExpr.getPrimitiveType());
            }

            public ValueExpr visit(AggregationExpr aggregationExpr) {
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(aggregationExpr.getPropertyPath());
                if (c == null) {
                    Class propertyType = propertyHelper.getPrimitivePropertyType(targetEntityMetadata, aggregationExpr.getPropertyPath().asArrayPath());
                    propertyType = FieldAccumulator.getOutputType((AggregationFunction)aggregationExpr.getAggregationType(), (Class)propertyType);
                    int idx = columns.size();
                    c = new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType);
                    columns.put(aggregationExpr.getPropertyPath(), c);
                    return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), propertyType);
                }
                return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), aggregationExpr.getPrimitiveType());
            }
        }
        return (BooleanExpr)expr.acceptVisitor((Visitor)new PropertyReplacer());
    }

    private BaseQuery<?> buildQueryWithRepeatedAggregations(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, String havingClause, LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, int noOfGroupingColumns, IndexedQueryMode queryMode) {
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, queryString, namedParameters, startOffset, maxResults);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(SyntaxTreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery<?> baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr), queryMode);
        LinkedList<FieldAccumulator> secondPhaseAccumulators = new LinkedList<FieldAccumulator>();
        LinkedList<FieldAccumulator> thirdPhaseAccumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (c.getColumnIndex() > 0) {
                secondPhaseQuery.append(", ");
            }
            if (p instanceof AggregationPropertyPath) {
                FieldAccumulator acc = FieldAccumulator.makeAccumulator((AggregationFunction)((AggregationPropertyPath)p).getAggregationFunction(), (int)c.getColumnIndex(), (int)c.getColumnIndex(), (Class)c.getPropertyType());
                if (this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) {
                    secondPhaseAccumulators.add(acc);
                    if (((AggregationPropertyPath)p).getAggregationFunction() == AggregationFunction.COUNT) {
                        c = new RowPropertyHelper.ColumnMetadata(c.getColumnIndex(), c.getColumnName(), Long.class);
                        acc = FieldAccumulator.makeAccumulator((AggregationFunction)AggregationFunction.SUM, (int)c.getColumnIndex(), (int)c.getColumnIndex(), Long.class);
                    }
                } else {
                    secondPhaseAccumulators.add(null);
                }
                thirdPhaseAccumulators.add(acc);
            } else {
                secondPhaseAccumulators.add(null);
            }
            secondPhaseQuery.append("_gen0").append('.').append(p.asStringPath());
            _columns[c.getColumnIndex()] = c;
        }
        secondPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        HybridQuery projectingAggregatingQuery = new HybridQuery(queryFactory, this.cache, secondPhaseQueryStr, namedParameters, this.getObjectFilter(this.matcher, secondPhaseQueryStr, namedParameters, secondPhaseAccumulators), -1L, -1, baseQuery);
        StringBuilder thirdPhaseQuery = new StringBuilder();
        thirdPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                thirdPhaseQuery.append(", ");
            }
            thirdPhaseQuery.append(c.getColumnName());
        }
        thirdPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            thirdPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            thirdPhaseQuery.append(" ORDER BY ");
            boolean isFirst = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    thirdPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                thirdPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String thirdPhaseQueryStr = thirdPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, thirdPhaseQueryStr, namedParameters, noOfGroupingColumns, thirdPhaseAccumulators, true, this.getObjectFilter((Matcher)new RowMatcher(_columns), thirdPhaseQueryStr, namedParameters, null), startOffset, maxResults, (BaseQuery)projectingAggregatingQuery);
    }

    protected BaseQuery<?> buildQueryNoAggregations(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, IndexedQueryMode queryMode) {
        BooleShannonExpansion bse;
        BooleanExpr expansion;
        BooleanExpr normalizedWhereClause;
        boolean isFullTextQuery;
        if (parsingResult.hasGroupingOrAggregations()) {
            throw Log.CONTAINER.queryMustNotUseGroupingOrAggregation();
        }
        if (!this.isIndexed && parsingResult.getWhereClause() != null && (isFullTextQuery = ((Boolean)parsingResult.getWhereClause().acceptVisitor((Visitor)FullTextVisitor.INSTANCE)).booleanValue())) {
            throw new IllegalStateException("The cache must be indexed in order to use full-text queries.");
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
                throw Log.CONTAINER.multivaluedPropertyCannotBeUsedInOrderBy(p.toString());
            }
        }
        if (parsingResult.getProjectedPaths() != null) {
            for (PropertyPath p : parsingResult.getProjectedPaths()) {
                if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
                throw Log.CONTAINER.multivaluedPropertyCannotBeProjected(p.asStringPath());
            }
        }
        if ((normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause())) == ConstantBooleanExpr.FALSE) {
            return new EmptyResultQuery(queryFactory, this.cache, queryString, namedParameters, startOffset, maxResults);
        }
        if (!this.isIndexed) {
            return new EmbeddedQuery((org.infinispan.query.core.impl.QueryEngine)this, queryFactory, this.cache, queryString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        IndexedFieldProvider.FieldIndexingMetadata fieldIndexingMetadata = this.propertyHelper.getIndexedFieldProvider().get(parsingResult.getTargetEntityMetadata());
        boolean allProjectionsAreStored = true;
        LinkedHashMap<PropertyPath, ArrayList<Integer>> projectionsMap = null;
        if (parsingResult.getProjectedPaths() != null) {
            projectionsMap = new LinkedHashMap<PropertyPath, ArrayList<Integer>>();
            for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
                PropertyPath p = parsingResult.getProjectedPaths()[i];
                ArrayList<Integer> idx = (ArrayList<Integer>)projectionsMap.get(p);
                if (idx == null) {
                    idx = new ArrayList<Integer>();
                    projectionsMap.put(p, idx);
                    if (!fieldIndexingMetadata.isStored(p.asArrayPath())) {
                        allProjectionsAreStored = false;
                    }
                }
                idx.add(i);
            }
        }
        boolean allSortFieldsAreStored = true;
        SortField[] sortFields = parsingResult.getSortFields();
        if (sortFields != null) {
            LinkedHashMap<String, SortField> sortFieldMap = new LinkedHashMap<String, SortField>();
            for (SortField sf : sortFields) {
                PropertyPath p = sf.getPath();
                String asStringPath = p.asStringPath();
                if (sortFieldMap.containsKey(asStringPath)) continue;
                sortFieldMap.put(asStringPath, sf);
                if (fieldIndexingMetadata.isStored(p.asArrayPath())) continue;
                allSortFieldsAreStored = false;
            }
            sortFields = sortFieldMap.values().toArray(new SortField[sortFieldMap.size()]);
        }
        if ((expansion = (bse = new BooleShannonExpansion(16, fieldIndexingMetadata)).expand(normalizedWhereClause)) == normalizedWhereClause) {
            String projectionQueryStr;
            if (allSortFieldsAreStored) {
                if (allProjectionsAreStored) {
                    RowProcessor rowProcessor = null;
                    if (parsingResult.getProjectedPaths() != null) {
                        if (projectionsMap.size() != parsingResult.getProjectedPaths().length) {
                            Class[] projectedTypes = new Class[projectionsMap.size()];
                            Object[] deduplicatedProjectedNullMarkers = parsingResult.getProjectedNullMarkers() != null ? new Object[projectedTypes.length] : null;
                            int[] map = new int[parsingResult.getProjectedPaths().length];
                            int j = 0;
                            for (List idx : projectionsMap.values()) {
                                int i = (Integer)idx.get(0);
                                projectedTypes[j] = parsingResult.getProjectedTypes()[i];
                                if (deduplicatedProjectedNullMarkers != null) {
                                    deduplicatedProjectedNullMarkers[j] = parsingResult.getProjectedNullMarkers()[i];
                                }
                                Iterator iterator = idx.iterator();
                                while (iterator.hasNext()) {
                                    int k = (Integer)iterator.next();
                                    map[k] = j;
                                }
                                ++j;
                            }
                            RowProcessor projectionProcessor = this.makeProjectionProcessor(projectedTypes, deduplicatedProjectedNullMarkers);
                            rowProcessor = inRow -> {
                                if (projectionProcessor != null) {
                                    inRow = (Object[])projectionProcessor.apply(inRow);
                                }
                                Object[] outRow = new Object[map.length];
                                for (int i = 0; i < map.length; ++i) {
                                    outRow[i] = inRow[map[i]];
                                }
                                return outRow;
                            };
                            PropertyPath[] deduplicatedProjection = projectionsMap.keySet().toArray(new PropertyPath[projectionsMap.size()]);
                            IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, deduplicatedProjection, projectedTypes, deduplicatedProjectedNullMarkers, sortFields);
                            return new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, parsingResult.getProjections(), rowProcessor, startOffset, maxResults, queryMode);
                        }
                        rowProcessor = this.makeProjectionProcessor(parsingResult.getProjectedTypes(), parsingResult.getProjectedNullMarkers());
                    }
                    return new EmbeddedLuceneQuery(this, queryFactory, namedParameters, parsingResult, parsingResult.getProjections(), rowProcessor, startOffset, maxResults, queryMode);
                }
                IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, null, null, null, sortFields);
                EmbeddedLuceneQuery indexQuery = new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, null, null, startOffset, maxResults, queryMode);
                projectionQueryStr = SyntaxTreePrinter.printTree((String)parsingResult.getTargetEntityName(), (PropertyPath[])parsingResult.getProjectedPaths(), null, null);
                return new HybridQuery(queryFactory, this.cache, projectionQueryStr, null, this.getObjectFilter(this.matcher, projectionQueryStr, null, null), -1L, -1, indexQuery);
            }
            IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, normalizedWhereClause, null, null, null, null);
            EmbeddedLuceneQuery indexQuery = new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, null, null, -1L, -1, queryMode);
            projectionQueryStr = SyntaxTreePrinter.printTree((String)parsingResult.getTargetEntityName(), (PropertyPath[])parsingResult.getProjectedPaths(), null, (SortField[])sortFields);
            return new HybridQuery(queryFactory, this.cache, projectionQueryStr, null, this.getObjectFilter(this.matcher, projectionQueryStr, null, null), startOffset, maxResults, indexQuery);
        }
        if (expansion == ConstantBooleanExpr.TRUE) {
            return new EmbeddedQuery((org.infinispan.query.core.impl.QueryEngine)this, queryFactory, this.cache, queryString, namedParameters, parsingResult.getProjections(), startOffset, maxResults);
        }
        IckleParsingResult<TypeMetadata> fpr = this.makeFilterParsingResult(parsingResult, expansion, null, null, null, null);
        EmbeddedLuceneQuery expandedQuery = new EmbeddedLuceneQuery(this, queryFactory, namedParameters, fpr, null, null, -1L, -1, queryMode);
        return new HybridQuery(queryFactory, this.cache, queryString, namedParameters, this.getObjectFilter(this.matcher, queryString, namedParameters, null), startOffset, maxResults, expandedQuery);
    }

    private IckleParsingResult<TypeMetadata> makeFilterParsingResult(IckleParsingResult<TypeMetadata> parsingResult, BooleanExpr normalizedWhereClause, PropertyPath[] projection, Class<?>[] projectedTypes, Object[] projectedNullMarkers, SortField[] sortFields) {
        String queryString = SyntaxTreePrinter.printTree((String)parsingResult.getTargetEntityName(), (PropertyPath[])projection, (BooleanExpr)normalizedWhereClause, (SortField[])sortFields);
        return new IckleParsingResult(queryString, parsingResult.getParameterNames(), normalizedWhereClause, null, parsingResult.getTargetEntityName(), parsingResult.getTargetEntityMetadata(), projection, (Class[])projectedTypes, projectedNullMarkers, null, sortFields);
    }

    protected RowProcessor makeProjectionProcessor(Class<?>[] projectedTypes, Object[] projectedNullMarkers) {
        return null;
    }

    public <E> IndexedQuery<E> buildCacheQuery(Query luceneQuery, KeyTransformationHandler keyTransformationHandler, TimeoutExceptionFactory timeoutExceptionFactory, Class<?> entity) {
        return new CacheQueryImpl(luceneQuery, this.getSearchFactory(), this.cache, keyTransformationHandler, timeoutExceptionFactory, entity);
    }

    public HsQueryRequest createHsQuery(String queryString, IndexedTypeMap<CustomTypeMetadata> metadata, Map<String, Object> nameParameters) {
        String[] projections;
        IckleParsingResult<TypeMetadata> parsingResult = this.parse(queryString);
        if (parsingResult.hasGroupingOrAggregations()) {
            throw Log.CONTAINER.groupAggregationsNotSupported();
        }
        LuceneQueryParsingResult<TypeMetadata> luceneParsingResult = this.transformParsingResult(parsingResult, nameParameters);
        Query luceneQuery = this.makeTypeQuery(luceneParsingResult.getQuery(), luceneParsingResult.getTargetEntityName());
        SearchIntegrator searchFactory = this.getSearchFactory();
        HSQuery hsQuery = metadata == null ? searchFactory.createHSQuery(luceneQuery, new Class[]{this.getTargetedClass(parsingResult)}) : searchFactory.createHSQuery(luceneQuery, metadata);
        Sort sort = luceneParsingResult.getSort();
        if (sort != null) {
            hsQuery.sort(sort);
        }
        if ((projections = luceneParsingResult.getProjections()) != null) {
            hsQuery.projection(projections);
        }
        return new HsQueryRequest(hsQuery, sort, projections);
    }

    public <E> IndexedQuery<E> buildCacheQuery(QueryDefinition queryDefinition, IndexedQueryMode indexedQueryMode, KeyTransformationHandler keyTransformationHandler, ExecutorService asyncExecutor, IndexedTypeMap<CustomTypeMetadata> indexedTypeMap) {
        if (!this.isIndexed) {
            throw Log.CONTAINER.cannotRunLuceneQueriesIfNotIndexed(this.cache.getName());
        }
        if (indexedQueryMode == IndexedQueryMode.BROADCAST) {
            return new ClusteredCacheQueryImpl(queryDefinition, asyncExecutor, this.cache, keyTransformationHandler, indexedTypeMap);
        }
        queryDefinition.initialize(this.cache);
        return new CacheQueryImpl(queryDefinition.getHsQuery(), this.cache, keyTransformationHandler);
    }

    public <E> IndexedQuery<E> buildCacheQuery(String queryString, IndexedQueryMode indexedQueryMode, KeyTransformationHandler keyTransformationHandler, TimeoutExceptionFactory timeoutExceptionFactory, ExecutorService asyncExecutor) {
        CacheQuery cacheQuery;
        IckleParsingResult<TypeMetadata> parsingResult;
        if (!this.isIndexed) {
            throw Log.CONTAINER.cannotRunLuceneQueriesIfNotIndexed(this.cache.getName());
        }
        if (log.isDebugEnabled()) {
            log.debugf("Building Lucene query for : %s", queryString);
        }
        if ((parsingResult = this.parse(queryString)).hasGroupingOrAggregations()) {
            throw Log.CONTAINER.groupAggregationsNotSupported();
        }
        LuceneQueryParsingResult<TypeMetadata> luceneParsingResult = this.transformParsingResult(parsingResult, Collections.emptyMap());
        Query luceneQuery = this.makeTypeQuery(luceneParsingResult.getQuery(), luceneParsingResult.getTargetEntityName());
        Class<TypeMetadata> targetedClass = this.getTargetedClass(parsingResult);
        if (indexedQueryMode == null) {
            indexedQueryMode = this.detectQueryMode();
        }
        if (indexedQueryMode == IndexedQueryMode.BROADCAST) {
            QueryDefinition queryDefinition = new QueryDefinition(queryString, queryEngineProvider);
            queryDefinition.setIndexedType(targetedClass);
            cacheQuery = new ClusteredCacheQueryImpl(queryDefinition, asyncExecutor, this.cache, keyTransformationHandler, null);
            queryDefinition.initialize(this.cache);
        } else {
            if (log.isDebugEnabled()) {
                log.debugf("The resulting Lucene query is : %s", luceneQuery.toString());
            }
            cacheQuery = new CacheQueryImpl(luceneQuery, this.getSearchFactory(), this.cache, keyTransformationHandler, timeoutExceptionFactory, targetedClass);
            if (luceneParsingResult.getSort() != null) {
                cacheQuery = cacheQuery.sort(luceneParsingResult.getSort());
            }
            if (luceneParsingResult.getProjections() != null) {
                cacheQuery = cacheQuery.projection(luceneParsingResult.getProjections());
            }
        }
        return cacheQuery;
    }

    <E> IndexedQuery<E> buildLuceneQuery(IckleParsingResult<TypeMetadata> ickleParsingResult, Map<String, Object> namedParameters, long startOffset, int maxResults) {
        return this.buildLuceneQuery(ickleParsingResult, namedParameters, startOffset, maxResults, IndexedQueryMode.FETCH);
    }

    private IndexedQueryMode detectQueryMode() {
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        return !cacheMode.isClustered() || cacheMode.isReplicated() ? IndexedQueryMode.FETCH : IndexedQueryMode.BROADCAST;
    }

    <E> IndexedQuery<E> buildLuceneQuery(IckleParsingResult<TypeMetadata> ickleParsingResult, Map<String, Object> namedParameters, long startOffset, int maxResults, IndexedQueryMode queryMode) {
        if (log.isDebugEnabled()) {
            log.debugf("Building Lucene query for : %s", ickleParsingResult.getQueryString());
        }
        if (!this.isIndexed) {
            throw Log.CONTAINER.cannotRunLuceneQueriesIfNotIndexed(this.cache.getName());
        }
        LuceneQueryParsingResult<TypeMetadata> luceneParsingResult = this.transformParsingResult(ickleParsingResult, namedParameters);
        Query luceneQuery = this.makeTypeQuery(luceneParsingResult.getQuery(), luceneParsingResult.getTargetEntityName());
        if (log.isDebugEnabled()) {
            log.debugf("The resulting Lucene query is : %s", luceneQuery.toString());
        }
        if (queryMode == null) {
            queryMode = this.detectQueryMode();
        }
        CacheQuery<Object> cacheQuery = this.makeCacheQuery(ickleParsingResult, luceneQuery, queryMode, namedParameters);
        if (queryMode != IndexedQueryMode.BROADCAST) {
            if (luceneParsingResult.getSort() != null) {
                cacheQuery = cacheQuery.sort(luceneParsingResult.getSort());
            }
            if (luceneParsingResult.getProjections() != null) {
                cacheQuery = cacheQuery.projection(luceneParsingResult.getProjections());
            }
        }
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults > 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return cacheQuery;
    }

    private LuceneQueryParsingResult<TypeMetadata> transformParsingResult(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters) {
        return this.queryCache != null && parsingResult.getParameterNames().isEmpty() ? (LuceneQueryParsingResult)this.queryCache.get(this.cache.getName(), parsingResult.getQueryString(), null, LuceneQueryParsingResult.class, (queryString, accumulators) -> this.transformToLuceneQueryParsingResult(parsingResult, namedParameters)) : this.transformToLuceneQueryParsingResult(parsingResult, namedParameters);
    }

    private LuceneQueryParsingResult<TypeMetadata> transformToLuceneQueryParsingResult(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters) {
        return new LuceneQueryMaker<TypeMetadata>(this.getSearchFactory(), this.fieldBridgeAndAnalyzerProvider).transform(parsingResult, namedParameters, this.getTargetedClass(parsingResult));
    }

    public IckleParsingResult<TypeMetadata> parse(String queryString) {
        return super.parse(queryString);
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        return query;
    }

    protected Class<?> getTargetedClass(IckleParsingResult<?> parsingResult) {
        return (Class)parsingResult.getTargetEntityMetadata();
    }

    protected IndexedQuery<?> makeCacheQuery(IckleParsingResult<TypeMetadata> ickleParsingResult, Query luceneQuery, IndexedQueryMode queryMode, Map<String, Object> namedParameters) {
        if (queryMode == IndexedQueryMode.BROADCAST) {
            QueryDefinition queryDefinition = new QueryDefinition(ickleParsingResult.getQueryString(), queryEngineProvider);
            queryDefinition.setNamedParameters(namedParameters);
            return (IndexedQuery)this.getSearchManager().getQuery(queryDefinition, queryMode, null);
        }
        return (IndexedQuery)this.getSearchManager().getQuery(luceneQuery, queryMode, this.getTargetedClass(ickleParsingResult));
    }

    @FunctionalInterface
    protected static interface RowProcessor
    extends Function<Object[], Object[]> {
    }
}

