/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.IndexedQuery;

final class EmbeddedLuceneQuery<TypeMetadata, T>
extends BaseQuery<T> {
    private final QueryEngine<TypeMetadata> queryEngine;
    private final QueryEngine.RowProcessor rowProcessor;
    private final IckleParsingResult<TypeMetadata> parsingResult;
    private IndexedQuery<T> cacheQuery;
    private final IndexedQueryMode queryMode;

    EmbeddedLuceneQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, Map<String, Object> namedParameters, IckleParsingResult<TypeMetadata> parsingResult, String[] projection, QueryEngine.RowProcessor rowProcessor, long startOffset, int maxResults, IndexedQueryMode queryMode) {
        super(queryFactory, parsingResult.getQueryString(), namedParameters, projection, startOffset, maxResults);
        if (rowProcessor != null && (projection == null || projection.length == 0)) {
            throw new IllegalArgumentException("A RowProcessor can only be specified with projections");
        }
        this.queryEngine = queryEngine;
        this.queryMode = queryMode;
        this.rowProcessor = rowProcessor;
        this.parsingResult = parsingResult;
    }

    public void resetQuery() {
        this.cacheQuery = null;
    }

    private IndexedQuery<T> createCacheQuery() {
        if (this.cacheQuery == null) {
            this.validateNamedParameters();
            this.cacheQuery = this.queryEngine.buildLuceneQuery(this.parsingResult, this.namedParameters, this.startOffset, this.maxResults, this.queryMode);
            if (this.timeout > 0L) {
                this.cacheQuery.timeout(this.timeout, TimeUnit.NANOSECONDS);
            }
        }
        return this.cacheQuery;
    }

    public List<T> list() {
        return this.execute().list();
    }

    public QueryResult<T> execute() {
        List results = StreamSupport.stream(this.spliterator(), false).collect(Collectors.toList());
        long hits = this.createCacheQuery().getResultSize();
        return new QueryResultImpl(hits, results);
    }

    public CloseableIterator<T> iterator() {
        MappingIterator iterator = this.createCacheQuery().iterator();
        return this.rowProcessor == null ? iterator : new MappingIterator((CloseableIterator)iterator, t -> this.rowProcessor.apply((Object[])t));
    }

    public int getResultSize() {
        return this.createCacheQuery().getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + 125;
    }
}

