/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryOptionsStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQuerySelectStep;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.query.dsl.SearchQueryDslExtension;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.infinispan.query.dsl.embedded.impl.SearchProjectionInfo;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;

public class SearchQueryBuilder {
    private final SearchSession querySession;
    private final SearchScope<?> scope;
    private final SearchProjectionInfo projectionInfo;
    private final SearchPredicate predicate;
    private final SearchSort sort;
    private Collection<String> routingKeys = Collections.emptySet();
    private Long timeout;
    private TimeUnit timeUnit;

    public SearchQueryBuilder(SearchSession querySession, SearchScope<?> scope, SearchProjectionInfo projectionInfo, SearchPredicate predicate, SearchSort sort) {
        this.querySession = querySession;
        this.scope = scope;
        this.projectionInfo = projectionInfo;
        this.predicate = predicate;
        this.sort = sort;
    }

    public LuceneSearchQuery<?> build() {
        return this.build(this.projectionInfo.getProjection());
    }

    public LuceneSearchQuery<DocumentReference> documentReference() {
        return this.build(this.scope.projection().documentReference().toProjection());
    }

    public void routeOnSegments(BitSet segments) {
        this.routingKeys = segments.stream().mapToObj(String::valueOf).collect(Collectors.toList());
    }

    public void noRouting() {
        this.routingKeys = Collections.emptySet();
    }

    public boolean hasEntityProjection() {
        return this.projectionInfo.isEntityProjection();
    }

    public Sort getLuceneSort() {
        return this.documentReference().luceneSort();
    }

    private <T> LuceneSearchQuery<T> build(SearchProjection<T> searchProjection) {
        LuceneSearchQueryOptionsStep queryOptionsStep = (LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQueryOptionsStep)((LuceneSearchQuerySelectStep)this.querySession.search(this.scope).extension((SearchQueryDslExtension)LuceneExtension.get())).select(searchProjection).where(this.predicate)).sort(this.sort)).routing(this.routingKeys);
        if (this.timeout != null && this.timeUnit != null) {
            queryOptionsStep = (LuceneSearchQueryOptionsStep)queryOptionsStep.failAfter(this.timeout.longValue(), this.timeUnit);
        }
        return queryOptionsStep.toQuery();
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }
}

