/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.query.Indexer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.massindex.IndexLock;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.query.impl.massindex.MassIndexerLockFactory;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="MassIndexer", description="Component that rebuilds the Lucene index from the cached data")
@Scope(value=Scopes.NAMED_CACHE)
public class DistributedExecutorMassIndexer
implements Indexer {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedExecutorMassIndexer.class, Log.class);
    private final AdvancedCache<?, ?> cache;
    private final IndexUpdater indexUpdater;
    private final ClusterExecutor executor;
    private final BlockingManager blockingManager;
    private final IndexLock lock;
    private final AuthorizationHelper authorizationHelper;
    private volatile boolean isRunning = false;
    private static final TriConsumer<Address, Void, Throwable> TRI_CONSUMER = (a, v, t) -> {
        if (t != null) {
            throw new CacheException(t);
        }
    };

    public DistributedExecutorMassIndexer(AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.cache = cache;
        this.indexUpdater = new IndexUpdater(cache, keyTransformationHandler);
        this.executor = cache.getCacheManager().executor();
        this.blockingManager = (BlockingManager)cache.getCacheManager().getGlobalComponentRegistry().getComponent(BlockingManager.class);
        this.lock = MassIndexerLockFactory.buildLock(cache);
        this.authorizationHelper = (AuthorizationHelper)cache.getComponentRegistry().getComponent(AuthorizationHelper.class);
    }

    @ManagedOperation(description="Starts rebuilding the index", displayName="Rebuild index")
    public void start() {
        CompletionStages.join(this.executeInternal(false, new Class[0]));
    }

    @Override
    public CompletionStage<Void> run() {
        return this.executeInternal(false, new Class[0]).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> run(Object ... keys) {
        this.authorizationHelper.checkPermission(AuthorizationPermission.ADMIN);
        CompletableFuture future = null;
        HashSet<Object> keySet = new HashSet<Object>();
        for (Object key : keys) {
            if (this.cache.containsKey(key)) {
                keySet.add(key);
                continue;
            }
            LOG.warn("cache contains no mapping for the key");
        }
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
        };
        if (keySet.size() > 0) {
            IndexWorker indexWorker = new IndexWorker(this.cache.getName(), null, false, keySet);
            future = this.executor.submitConsumer((Function)indexWorker, triConsumer);
        }
        return future != null ? future : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> remove() {
        return this.executeInternal(true, new Class[0]).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> remove(Class<?> ... entities) {
        return this.executeInternal(true, entities);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private CompletionStage<Void> executeInternal(boolean skipIndex, Class<?> ... entities) {
        this.authorizationHelper.checkPermission(AuthorizationPermission.ADMIN);
        CompletionStage<Boolean> lockStage = this.lock.lock();
        return lockStage.thenCompose(acquired -> {
            if (!acquired.booleanValue()) {
                return CompletableFutures.completedExceptionFuture((Throwable)new MassIndexerAlreadyStartedException());
            }
            this.isRunning = true;
            List<Class<?>> javaClasses = entities.length == 0 ? this.indexUpdater.allJavaClasses() : Arrays.asList(entities);
            LinkedList<Class> toFlush = new LinkedList<Class>(javaClasses);
            BiConsumer<Void, Throwable> flushIfNeeded = (v, t) -> {
                try {
                    this.indexUpdater.flush(toFlush);
                    this.indexUpdater.refresh(toFlush);
                }
                finally {
                    CompletionStages.join(this.lock.unlock());
                    this.isRunning = false;
                }
            };
            try {
                IndexWorker indexWork = new IndexWorker(this.cache.getName(), javaClasses, skipIndex, null);
                CompletableFuture future = this.executor.timeout(Long.MAX_VALUE, TimeUnit.SECONDS).submitConsumer((Function)indexWork, TRI_CONSUMER);
                return this.blockingManager.whenCompleteBlocking((CompletionStage)future, flushIfNeeded, (Object)this);
            }
            catch (Throwable t2) {
                this.lock.unlock();
                this.isRunning = false;
                return CompletableFutures.completedExceptionFuture((Throwable)t2);
            }
        });
    }
}

