/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.util.common.impl.Closer;
import org.infinispan.search.mapper.common.EntityReference;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.mapping.impl.InfinispanTypeContextContainer;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.scope.impl.SearchScopeImpl;
import org.infinispan.search.mapper.session.SearchSession;
import org.infinispan.search.mapper.session.impl.InfinispanSearchSession;
import org.infinispan.search.mapper.session.impl.InfinispanSearchSessionMappingContext;
import org.infinispan.search.mapper.work.SearchIndexer;
import org.infinispan.search.mapper.work.impl.SearchIndexerImpl;

public class InfinispanMapping
extends AbstractPojoMappingImplementor<SearchMapping>
implements SearchMapping,
InfinispanSearchSessionMappingContext {
    private final InfinispanTypeContextContainer typeContextContainer;
    private final EntityLoader<EntityReference, ?> entityLoader;
    private final EntityConverter entityConverter;
    private final SearchSession mappingSession;
    private final SearchIndexer searchIndexer;
    private final Map<String, Class<?>> allIndexedTypes;
    private final Map<String, Class<?>> allTypes;
    private SearchIntegration integration;
    private boolean close = false;

    InfinispanMapping(PojoMappingDelegate mappingDelegate, InfinispanTypeContextContainer typeContextContainer, EntityLoader<EntityReference, ?> entityLoader, EntityConverter entityConverter) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.entityLoader = entityLoader;
        this.entityConverter = entityConverter;
        this.mappingSession = new InfinispanSearchSession(this, typeContextContainer);
        this.searchIndexer = new SearchIndexerImpl(this.mappingSession.createIndexer(), entityConverter, typeContextContainer);
        this.allIndexedTypes = this.collectAllIndexedTypes();
        this.allTypes = this.collectEntities();
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(SearchIntegration::close, (Object)this.integration);
            this.close = true;
        }
    }

    @Override
    public <E> SearchScope<E> scope(Collection<? extends Class<? extends E>> targetedTypes) {
        return this.createScope(targetedTypes);
    }

    @Override
    public SearchScope<?> scopeAll() {
        return this.getSearchScope(this.typeContextContainer.allTypeIdentifiers());
    }

    @Override
    public SearchScope<?> scopeFromJavaClasses(Collection<Class<?>> javaClasses) {
        if (this.entityConverter == null || !javaClasses.contains(this.entityConverter.targetType())) {
            return this.createScope(javaClasses);
        }
        List targetedTypes = this.typeContextContainer.allTypeIdentifiers().stream().filter(typeIdentifier -> typeIdentifier.javaClass().equals(this.entityConverter.convertedType()) || javaClasses.contains(typeIdentifier.javaClass())).collect(Collectors.toList());
        return this.getSearchScope(targetedTypes);
    }

    public SearchMapping toConcreteType() {
        return this;
    }

    @Override
    public <E> SearchScopeImpl<E> createScope(Collection<? extends Class<? extends E>> classes) {
        ArrayList<PojoRawTypeIdentifier<PojoRawTypeIdentifier>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<PojoRawTypeIdentifier>>(classes.size());
        for (Class<E> clazz : classes) {
            typeIdentifiers.add(PojoRawTypeIdentifier.of(clazz));
        }
        return this.getSearchScope(typeIdentifiers);
    }

    public <E> SearchScopeImpl<E> createScope(Class<E> expectedSuperType, Collection<String> entityNames) {
        ArrayList<PojoRawTypeIdentifier<PojoRawTypeIdentifier>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<PojoRawTypeIdentifier>>(entityNames.size());
        for (String entityName : entityNames) {
            typeIdentifiers.add(PojoRawTypeIdentifier.of(expectedSuperType, (String)entityName));
        }
        return this.getSearchScope(typeIdentifiers);
    }

    @Override
    public boolean isClose() {
        return this.close;
    }

    @Override
    public SearchSession getMappingSession() {
        return this.mappingSession;
    }

    @Override
    public SearchIndexer getSearchIndexer() {
        return this.searchIndexer;
    }

    @Override
    public SearchIndexedEntity indexedEntity(Class<?> entityType) {
        return this.typeContextContainer.getIndexedByEntityType(entityType);
    }

    @Override
    public SearchIndexedEntity indexedEntity(String entityName) {
        return this.typeContextContainer.getIndexedByEntityName(entityName);
    }

    @Override
    public Map<String, Class<?>> allIndexedTypes() {
        return this.allIndexedTypes;
    }

    @Override
    public Map<String, Class<?>> getEntities() {
        return this.allTypes;
    }

    @Override
    public boolean isIndexedType(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> c = value.getClass();
        return this.allIndexedTypes.containsValue(c);
    }

    @Override
    public FailureHandler getFailureHandler() {
        return this.delegate().failureHandler();
    }

    public void setIntegration(SearchIntegration integration) {
        this.integration = integration;
    }

    private Map<String, Class<?>> collectAllIndexedTypes() {
        Map<String, Class> entities = this.typeContextContainer.getAllIndexed().stream().collect(Collectors.toMap(a -> a.javaClass().getName(), SearchIndexedEntity::javaClass));
        if (this.entityConverter != null) {
            entities.put(this.entityConverter.targetType().getName(), this.entityConverter.targetType());
        }
        return Collections.unmodifiableMap(entities);
    }

    private Map<String, Class<?>> collectEntities() {
        return this.typeContextContainer.getEntityClassByEntityName();
    }

    private <E> SearchScopeImpl<E> getSearchScope(Collection<PojoRawTypeIdentifier<? extends E>> typeIdentifiers) {
        PojoScopeDelegate pojoScopeDelegate = this.delegate().createPojoScope((PojoScopeMappingContext)this, typeIdentifiers, typeIdentifier -> typeIdentifier);
        return new SearchScopeImpl((BackendMappingContext)this, pojoScopeDelegate, this.entityLoader);
    }
}

