/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.session.impl;

import java.util.Collection;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.util.common.AssertionFailure;
import org.infinispan.search.mapper.common.EntityReference;
import org.infinispan.search.mapper.common.impl.EntityReferenceImpl;
import org.infinispan.search.mapper.model.impl.InfinispanRuntimeIntrospector;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.scope.impl.SearchScopeImpl;
import org.infinispan.search.mapper.session.SearchSession;
import org.infinispan.search.mapper.session.impl.InfinispanIndexedTypeContext;
import org.infinispan.search.mapper.session.impl.InfinispanSearchSessionMappingContext;
import org.infinispan.search.mapper.session.impl.InfinispanTypeContextProvider;

public class InfinispanSearchSession
extends AbstractPojoSearchSession
implements SearchSession,
DocumentReferenceConverter<EntityReference>,
EntityReferenceFactory<EntityReference> {
    private final InfinispanSearchSessionMappingContext mappingContext;
    private final InfinispanTypeContextProvider typeContextProvider;

    public InfinispanSearchSession(InfinispanSearchSessionMappingContext mappingContext, InfinispanTypeContextProvider typeContextProvider) {
        super((PojoSearchSessionMappingContext)mappingContext);
        this.mappingContext = mappingContext;
        this.typeContextProvider = typeContextProvider;
    }

    @Override
    public void close() {
    }

    @Override
    public <E> SearchQuerySelectStep<?, EntityReference, E, ?, ?, ?> search(SearchScope<E> scope) {
        return this.search((SearchScopeImpl)scope);
    }

    public <E> SearchScopeImpl<E> scope(Collection<? extends Class<? extends E>> types) {
        return this.mappingContext.createScope(types);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.mappingContext.createScope(expectedSuperType, entityNames);
    }

    public EntityReference fromDocumentReference(DocumentReference reference) {
        InfinispanIndexedTypeContext typeContext = this.typeContextProvider.getTypeContextByEntityName(reference.typeName());
        if (typeContext == null) {
            throw new AssertionFailure("Document reference " + reference + " refers to an unknown index");
        }
        Object id = typeContext.getIdentifierMapping().fromDocumentIdentifier(reference.id(), (BridgeSessionContext)this);
        return new EntityReferenceImpl(typeContext.getTypeIdentifier(), typeContext.getEntityName(), id);
    }

    @Override
    public PojoIndexer createIndexer() {
        return super.createIndexer();
    }

    private <E> SearchQuerySelectStep<?, EntityReference, E, ?, ?, ?> search(SearchScopeImpl<E> scope) {
        return scope.search((BackendSessionContext)this, this);
    }

    public String tenantIdentifier() {
        return null;
    }

    public InfinispanRuntimeIntrospector runtimeIntrospector() {
        return new InfinispanRuntimeIntrospector();
    }

    public EntityReferenceFactory entityReferenceFactory() {
        return this;
    }

    public EntityReference createEntityReference(String typeName, Object identifier) {
        InfinispanIndexedTypeContext typeContext = this.typeContextProvider.getTypeContextByEntityName(typeName);
        if (typeContext == null) {
            throw new AssertionFailure("Type name " + typeName + " refers to an unknown type");
        }
        return new EntityReferenceImpl(typeContext.getTypeIdentifier(), typeContext.getEntityName(), identifier);
    }
}

