/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.query.backend.WrappingErrorHandler;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;

public class StaticTestingErrorHandler
implements ErrorHandler {
    private final AtomicReference faulty = new AtomicReference();

    public void handle(ErrorContext context) {
        this.faulty.compareAndSet(null, new ThrowableWrapper(context.getOperationAtFault().toString(), context.getThrowable()));
    }

    public void handleException(String errorMsg, Throwable exception) {
        this.faulty.compareAndSet(null, new ThrowableWrapper(errorMsg, exception));
    }

    private Object getAndReset() {
        return this.faulty.getAndSet(null);
    }

    public static void assertAllGood(Cache cache) {
        StaticTestingErrorHandler instance = StaticTestingErrorHandler.extract(cache);
        instance.assertNoErrors();
    }

    public static void assertAllGood(Cache ... caches) {
        for (Cache cache : caches) {
            StaticTestingErrorHandler.assertAllGood(cache);
        }
    }

    private void assertNoErrors() {
        Object fault = this.getAndReset();
        if (fault != null) {
            AssertJUnit.fail((String)fault.toString());
        }
    }

    public static StaticTestingErrorHandler extract(Cache cache) {
        SearchIntegrator searchFactory = (SearchIntegrator)TestingUtil.extractComponent((Cache)cache, SearchIntegrator.class);
        ErrorHandler errorHandler = searchFactory.getErrorHandler();
        AssertJUnit.assertNotNull((Object)errorHandler);
        if (errorHandler instanceof WrappingErrorHandler) {
            errorHandler = ((WrappingErrorHandler)errorHandler).unwrap();
        }
        AssertJUnit.assertTrue((boolean)(errorHandler instanceof StaticTestingErrorHandler));
        return (StaticTestingErrorHandler)errorHandler;
    }

    public static class ThrowableWrapper {
        private final String errorMsg;
        private final Throwable exception;

        public ThrowableWrapper(String errorMsg, Throwable exception) {
            this.errorMsg = errorMsg;
            this.exception = exception;
        }

        public String toString() {
            StringWriter w = new StringWriter();
            w.append(String.valueOf(this.errorMsg));
            if (this.exception != null) {
                w.append(' ');
                this.exception.printStackTrace(new PrintWriter(w));
            }
            return w.toString();
        }
    }
}

