/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.performance;

import java.io.IOException;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.performance.TuningOptionsAppliedTest")
public class TuningOptionsAppliedTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyFSDirectoryOptions() throws IOException {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml((String)"nrt-performance-writer.xml");
        try {
            SearchIntegrator si = this.extractSearchFactoryImplementor(embeddedCacheManager);
            NRTIndexManager nrti = this.verifyShardingOptions(si, 6);
            this.verifyIndexWriterOptions(nrti, 220, 4096, 30);
            this.verifyUsesFSDirectory(nrti);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
    }

    private SearchIntegrator extractSearchFactoryImplementor(EmbeddedCacheManager embeddedCacheManager) {
        Cache cache = embeddedCacheManager.getCache("Indexed");
        cache.put((Object)"hey this type exists", (Object)new Person("id", "name", 3));
        return (SearchIntegrator)TestingUtil.extractComponent((Cache)cache, SearchIntegrator.class);
    }

    private NRTIndexManager verifyShardingOptions(SearchIntegrator searchIntegrator, int expectedShards) {
        for (int i = 0; i < expectedShards; ++i) {
            Assert.assertNotNull((Object)searchIntegrator.getIndexManager("person." + i), (String)("person." + i + " IndexManager missing!"));
        }
        Assert.assertNull((Object)searchIntegrator.getIndexManager("person." + expectedShards), (String)"An IndexManager too much was created!");
        IndexManager indexManager = searchIntegrator.getIndexManager("person.0");
        Assert.assertTrue((boolean)(indexManager instanceof NRTIndexManager));
        NRTIndexManager nrtIM = (NRTIndexManager)indexManager;
        return nrtIM;
    }

    private void verifyUsesFSDirectory(NRTIndexManager nrtIM) {
        DirectoryProvider directoryProvider = nrtIM.getDirectoryProvider();
        Assert.assertTrue((boolean)(directoryProvider instanceof FSDirectoryProvider));
    }

    private void verifyIndexWriterOptions(NRTIndexManager nrtIM, Integer expectedRAMBuffer, Integer expectedMaxMergeSize, Integer expectedMergeFactor) {
        LuceneIndexingParameters indexingParameters = nrtIM.getIndexingParameters();
        LuceneIndexingParameters.ParameterSet indexParameters = indexingParameters.getIndexParameters();
        Assert.assertEquals((Object)indexParameters.getCurrentValueFor(IndexWriterSetting.RAM_BUFFER_SIZE), (Object)expectedRAMBuffer);
        Assert.assertEquals((Object)indexParameters.getCurrentValueFor(IndexWriterSetting.MERGE_MAX_SIZE), (Object)expectedMaxMergeSize);
        Assert.assertEquals((Object)indexParameters.getCurrentValueFor(IndexWriterSetting.MERGE_FACTOR), (Object)expectedMergeFactor);
    }
}

