package org.infinispan.query;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.apache.lucene.search.Explanation;

/**
 * A cache-query is what will be returned when the getQuery() method is run on {@link org.infinispan.query.impl.SearchManagerImpl}. This object can
 * have methods such as list, setFirstResult,setMaxResults, setFetchSize, getResultSize and setSort.
 * <p/>
 *
 * @author Manik Surtani
 * @author Navin Surtani
 * @author Sanne Grinovero &lt;sanne@hibernate.org&gt; (C) 2011 Red Hat Inc.
 * @author Marko Luksa
 * @see org.infinispan.query.impl.SearchManagerImpl#getQuery(String)
 * @deprecated Since 11.0, replaced by {@link org.infinispan.query.dsl.Query} in the Query API and
 * {@link org.infinispan.query.impl.IndexedQuery} internally.
 */
@Deprecated
public interface CacheQuery<E> extends Iterable<E> {

   /**
    * Returns the results of a search as a list.
    *
    * @return list of objects that were found from the search.
    */
   List<E> list();

   /**
    * Returns the results of a search as a {@link ResultIterator}.
    *
    * Warning: the return type is an extension of {@link java.util.Iterator} which introduces a {@link ResultIterator#close()}
    * method. This close method needs to be invoked when the iteration is complete to avoid resource leakage.
    *
    * @param fetchOptions how to fetch results (see @link FetchOptions)
    * @return a QueryResultIterator which can be used to iterate through the results that were found.
    */
   ResultIterator<E> iterator(FetchOptions fetchOptions);

   /**
    * Returns the results of a search as a {@link ResultIterator}. This calls {@link CacheQuery#iterator(FetchOptions fetchOptions)}
    * with default FetchOptions; this implies eager loading of all results.
    *
    * @return a ResultIterator which can be used to iterate through the results that were found.
    */
   @Override
   ResultIterator<E> iterator();

   /**
    * Sets a result with a given index to the first result.
    *
    * @param index of result to be set to the first.
    * @throws IllegalArgumentException if the index given is less than zero.
    */
   CacheQuery<E> firstResult(int index);

   /**
    * Sets the maximum number of results to the number passed in as a parameter.
    *
    * @param numResults that are to be set to the maxResults.
    */
   CacheQuery<E> maxResults(int numResults);

   /**
    * Gets the total number of results matching the query, ignoring pagination (firstResult, maxResult).
    *
    * @return total number of results.
    */
   int getResultSize();

   /**
    * Return the Lucene {@link org.apache.lucene.search.Explanation}
    * object describing the score computation for the matching object/document
    * in the current query
    *
    * @param id The id of the document to test.
    * @return Lucene Explanation
    */
   Explanation explain(String id);

   /**
    * Set the timeout for this query. If the query hasn't finished processing before the timeout,
    * an exception will be thrown.
    *
    * @param timeout the timeout duration
    * @param timeUnit the time unit of the timeout parameter
    * @return
    */
   CacheQuery<E> timeout(long timeout, TimeUnit timeUnit);
}
