/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.File;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.blackbox.LocalCacheTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.LocalCachePerfProgrammaticConfTest")
public class LocalCachePerfProgrammaticConfTest
extends LocalCacheTest {
    private final String indexDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addKeyTransformer(CustomKey3.class, CustomKey3Transformer.class).addProperty("directory.type", "local-heap").addProperty("directory.root", this.indexDirectory).addProperty("thread_pool.size", "6").addProperty("index_defaults.indexing.queue_count", "6").addProperty("index_defaults.indexing.queue_size", "4096").addProperty("index_defaults.io.commit_interval", "10000").addProperty("index_defaults.sharding.strategy", "hash").addProperty("index_defaults.sharding.number_of_shards", "6").addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    protected void setup() throws Exception {
        Util.recursiveFileRemove((String)this.indexDirectory);
        boolean created = new File(this.indexDirectory).mkdirs();
        AssertJUnit.assertTrue((boolean)created);
        super.setup();
    }

    @Override
    protected void teardown() {
        try {
            super.teardown();
        }
        finally {
            Util.recursiveFileRemove((String)this.indexDirectory);
        }
    }
}

