/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.LocalIndexStateTransferTest")
public class LocalIndexSyncStateTransferTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, this.getBuilder());
    }

    protected ConfigurationBuilder getBuilder() {
        ConfigurationBuilder builder = LocalIndexSyncStateTransferTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("directory.type", "local-heap");
        return builder;
    }

    private void assertIndexesSynced() {
        List caches = this.caches();
        caches.forEach(this::assertIndexesSynced);
    }

    private void assertIndexesSynced(Cache<Integer, Object> c) {
        String address = c.getAdvancedCache().getRpcManager().getAddress().toString();
        Map<Class<?>, AtomicInteger> countPerEntity = this.getEntityCountPerClass(c);
        countPerEntity.forEach((entity, count) -> {
            Query q = Search.getQueryFactory((Cache)c).create("FROM " + entity.getName(), IndexedQueryMode.FETCH);
            Supplier<String> messageSupplier = () -> String.format("On node %s index contains %d entries for entity %s, but data container has %d", address, q.list().size(), entity.getName(), count.get());
            this.eventually(messageSupplier, () -> q.list().size() == count.get());
        });
    }

    protected Map<Class<?>, AtomicInteger> getEntityCountPerClass(Cache<Integer, Object> c) {
        HashMap countPerEntity = new HashMap();
        c.getAdvancedCache().getDataContainer().forEach(e -> {
            Class<?> entity = e.getValue().getClass();
            countPerEntity.computeIfAbsent(entity, aClass -> new AtomicInteger(0)).incrementAndGet();
        });
        return countPerEntity;
    }

    public void testIndexSyncedDuringST() {
        Cache cache = this.cache(0);
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)new Person("person" + i, "blurb" + i, i + 10));
        }
        this.assertIndexesSynced();
        this.addClusterEnabledCacheManager(QueryTestSCI.INSTANCE, this.getBuilder()).getCache();
        this.assertIndexesSynced();
        this.killMember(2);
        this.assertIndexesSynced();
    }
}

