/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.LocalCacheMassIndexerTest")
public class LocalCacheMassIndexerTest
extends SingleCacheManagerTest {
    private static final int NUM_ENTITIES = 50;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().enable().addIndexedEntity(Person.class).addProperty("directory.type", "local-heap");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    private long indexSize(Cache<?, ?> cache) {
        QueryFactory queryFactory = Search.getQueryFactory(cache);
        Query query = queryFactory.create("FROM " + Person.class.getName());
        return query.execute().hitCount().orElse(-1L);
    }

    private void fillData() {
        for (int i = 0; i < 50; ++i) {
            this.cache.put((Object)i, (Object)new Person("name" + i, "blurb" + i, i));
        }
    }

    @BeforeMethod
    public void clean() {
        this.cache.clear();
    }

    @Test
    public void testMassIndexer() {
        this.fillData();
        Indexer massIndexer = Search.getIndexer((Cache)this.cache);
        AssertJUnit.assertEquals((long)50L, (long)this.indexSize(this.cache));
        CompletionStages.join((CompletionStage)massIndexer.run());
        AssertJUnit.assertEquals((long)50L, (long)this.indexSize(this.cache));
        this.cache.clear();
        CompletionStages.join((CompletionStage)massIndexer.run());
        AssertJUnit.assertEquals((long)0L, (long)this.indexSize(this.cache));
        this.fillData();
        CompletionStages.join((CompletionStage)massIndexer.run());
        Assert.assertFalse((boolean)massIndexer.isRunning());
        AssertJUnit.assertEquals((long)50L, (long)this.indexSize(this.cache));
    }

    public void testPartiallyReindex() throws Exception {
        this.cache.getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put((Object)0, (Object)new Person("name0", "blurb0", 0));
        this.verifyFindsPerson(0, "name0");
        CompletionStages.join((CompletionStage)Search.getIndexer((Cache)this.cache).run(new Object[]{0}));
        this.verifyFindsPerson(1, "name0");
        this.cache.remove((Object)0);
        this.verifyFindsPerson(0, "name0");
    }

    protected void verifyFindsPerson(int expectedCount, String name) throws Exception {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        String q = String.format("FROM %s where name:'%s'", Person.class.getName(), name);
        Query cacheQuery = queryFactory.create(q);
        AssertJUnit.assertEquals((long)expectedCount, (long)cacheQuery.execute().hitCount().orElse(-1L));
    }
}

