/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.helper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.FailSafeFailureHandlerWrapper;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.infinispan.Cache;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.testng.AssertJUnit;

public class IndexAccessor {
    private final LuceneIndexManagerImpl indexManager;
    private final List<Shard> shardsForTests;
    private final IndexAccessorImpl indexAccessor;

    public static IndexAccessor of(Cache<?, ?> cache, Class<?> entityType) {
        return new IndexAccessor(cache, entityType);
    }

    public IndexAccessor(Cache<?, ?> cache, Class<?> entityType) {
        SearchMapping searchMapping = TestQueryHelperFactory.extractSearchMapping(cache);
        SearchIndexedEntity searchIndexedEntity = searchMapping.indexedEntity(entityType);
        if (searchIndexedEntity == null) {
            AssertJUnit.fail((String)("Entity " + entityType + " is not indexed."));
        }
        this.indexManager = (LuceneIndexManagerImpl)searchIndexedEntity.indexManager().unwrap(LuceneIndexManager.class);
        this.shardsForTests = this.indexManager.getShardsForTests();
        this.indexAccessor = this.shardsForTests.get(0).getIndexAccessorForTests();
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public List<Shard> getShardsForTests() {
        return this.shardsForTests;
    }

    public DirectoryReader getIndexReader() throws IOException {
        return this.indexAccessor.getIndexReader();
    }

    public Directory getDirectory() {
        return this.indexAccessor.getDirectoryForTests();
    }

    public static Sort extractSort(SearchQuery<?> searchQuery) {
        return (Sort)ReflectionUtil.getValue(searchQuery, (String)"luceneSort");
    }

    public static FailureHandler extractFailureHandler(Cache<?, ?> cache) {
        SearchIntegration searchIntegration = (SearchIntegration)ReflectionUtil.getValue((Object)TestQueryHelperFactory.extractSearchMapping(cache), (String)"integration");
        BeanHolder failureHandlerHolder = (BeanHolder)ReflectionUtil.getValue((Object)searchIntegration, (String)"failureHandlerHolder");
        FailureHandler failureHandler = (FailureHandler)failureHandlerHolder.get();
        if (failureHandler instanceof FailSafeFailureHandlerWrapper) {
            return (FailureHandler)ReflectionUtil.getValue((Object)failureHandler, (String)"delegate");
        }
        return failureHandler;
    }
}

