/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.infinispan.AdvancedCache;
import org.infinispan.encoding.DataConversion;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.remoting.transport.Address;

class DistributedIterator<E>
implements ResultIterator<E> {
    protected final AdvancedCache<?, ?> cache;
    private final DataConversion keyDataConversion;
    private int currentIndex = -1;
    private final int fetchSize;
    private final int resultSize;
    private final int maxResults;
    private final int firstResult;
    private final NodeTopDocs[] partialResults;
    private final int[] partialPositionNext;
    private final TopDocs mergedResults;

    DistributedIterator(Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, Map<Address, NodeTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.fetchSize = fetchSize;
        this.resultSize = resultSize;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.cache = cache;
        this.keyDataConversion = cache.getKeyDataConversion();
        int parallels = topDocsResponses.size();
        this.partialResults = new NodeTopDocs[parallels];
        TopFieldDocs[] partialTopDocs = sort != null ? new TopFieldDocs[parallels] : new TopDocs[parallels];
        this.partialPositionNext = new int[parallels];
        int i = 0;
        for (Map.Entry<Address, NodeTopDocs> entry : topDocsResponses.entrySet()) {
            this.partialResults[i] = entry.getValue();
            partialTopDocs[i] = this.partialResults[i].topDocs;
            ++i;
        }
        this.mergedResults = sort != null ? TopDocs.merge((Sort)sort, (int)firstResult, (int)maxResults, (TopFieldDocs[])partialTopDocs, (boolean)true) : TopDocs.merge((int)firstResult, (int)maxResults, (TopDocs[])partialTopDocs, (boolean)true);
    }

    @Override
    public void close() {
    }

    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        ScoreDoc scoreDoc = this.mergedResults.scoreDocs[this.currentIndex];
        int index = scoreDoc.shardIndex;
        if (this.partialPositionNext[index] == 0) {
            this.partialPositionNext[index] = this.findSpecificPosition(scoreDoc.doc, this.partialResults[index].topDocs);
        }
        int specificPosition = this.partialPositionNext[index];
        int n = index;
        this.partialPositionNext[n] = this.partialPositionNext[n] + 1;
        return this.fetchValue(specificPosition, this.partialResults[index]);
    }

    private int findSpecificPosition(int docId, TopDocs topDocs) {
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            if (topDocs.scoreDocs[i].doc != docId) continue;
            return i;
        }
        return 0;
    }

    protected E fetchValue(int scoreIndex, NodeTopDocs nodeTopDocs) {
        Object[] keys = nodeTopDocs.keys;
        if (keys != null && keys.length > 0) {
            return (E)this.cache.get(this.keyDataConversion.fromStorage(keys[scoreIndex]));
        }
        return (E)nodeTopDocs.projections[scoreIndex];
    }

    public final boolean hasNext() {
        int nextIndex = this.currentIndex + 1;
        return this.firstResult + nextIndex < this.resultSize && nextIndex < this.maxResults;
    }
}

