/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.List;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;

final class CQCreateEagerQuery
extends CQWorker {
    CQCreateEagerQuery() {
    }

    @Override
    QueryResponse perform(BitSet segments) {
        NodeTopDocs nodeTopDocs;
        SearchQueryBuilder query = this.queryDefinition.getSearchQuery();
        this.setFilter(segments);
        NodeTopDocs nodeTopDocs2 = nodeTopDocs = query.hasEntityProjection() ? this.collectKeys(query) : this.collectProjections(query);
        if (nodeTopDocs == null) {
            return new QueryResponse(0);
        }
        return new QueryResponse(nodeTopDocs);
    }

    private NodeTopDocs collectKeys(SearchQueryBuilder query) {
        LuceneSearchResult queryResult = (LuceneSearchResult)query.documentReference().fetchAll();
        if (queryResult.totalHitCount() == 0L) {
            return null;
        }
        Object[] keys = queryResult.hits().stream().map(hit -> hit.id()).map(id -> this.stringToKey((String)id)).toArray(Object[]::new);
        return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), keys, null);
    }

    private NodeTopDocs collectProjections(SearchQueryBuilder query) {
        LuceneSearchResult queryResult = (LuceneSearchResult)query.build().fetchAll();
        if (queryResult.totalHitCount() == 0L) {
            return null;
        }
        List hits = queryResult.hits();
        Object[] projections = hits.toArray(new Object[hits.size()]);
        return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), null, projections);
    }
}

