/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.UUID;
import org.infinispan.AdvancedCache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.QueryDefinition;

abstract class CQWorker {
    protected AdvancedCache<?, ?> cache;
    private KeyTransformationHandler keyTransformationHandler;
    protected QueryDefinition queryDefinition;
    protected UUID queryId;
    protected int docIndex;

    CQWorker() {
    }

    void initialize(AdvancedCache<?, ?> cache, QueryDefinition queryDefinition, UUID queryId, int docIndex) {
        this.cache = cache;
        this.keyTransformationHandler = ComponentRegistryUtils.getQueryInterceptor(cache).getKeyTransformationHandler();
        if (queryDefinition != null) {
            this.queryDefinition = queryDefinition;
            this.queryDefinition.initialize(cache);
        }
        this.queryId = queryId;
        this.docIndex = docIndex;
    }

    abstract QueryResponse perform(BitSet var1);

    void setFilter(BitSet segments) {
        SearchQueryBuilder searchQuery = this.queryDefinition.getSearchQuery();
        if (segments.cardinality() != this.cache.getCacheConfiguration().clustering().hash().numSegments()) {
            searchQuery.routeOnSegments(segments);
        } else {
            searchQuery.noRouting();
        }
    }

    Object stringToKey(String documentId) {
        return this.keyTransformationHandler.stringToKey(documentId);
    }
}

