/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.NoSuchElementException;
import org.infinispan.query.ResultIterator;

abstract class AbstractIterator<E>
implements ResultIterator<E> {
    private final Object[] buffer;
    private int index = 0;
    private int bufferIndex = -1;
    private final int lastIndex;

    protected AbstractIterator(int firstIndex, int lastIndex, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("fetchSize should be greater than 0");
        }
        this.index = firstIndex;
        this.lastIndex = lastIndex;
        int resultCount = lastIndex == -1 ? 0 : lastIndex + 1 - firstIndex;
        this.buffer = new Object[Math.min(fetchSize, resultCount)];
    }

    public boolean hasNext() {
        return this.index <= this.lastIndex;
    }

    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.mustInitializeBuffer()) {
            this.fillBuffer(this.index);
        }
        int indexToReturn = this.index - this.bufferIndex;
        ++this.index;
        return (E)this.buffer[indexToReturn];
    }

    private boolean mustInitializeBuffer() {
        return this.bufferIndex == -1 || this.index < this.bufferIndex || this.index >= this.bufferIndex + this.buffer.length;
    }

    private void fillBuffer(int startIndex) {
        this.bufferIndex = startIndex;
        int resultsToLoad = Math.min(this.buffer.length, this.lastIndex + 1 - this.bufferIndex);
        for (int i = 0; i < resultsToLoad; ++i) {
            this.buffer[i] = this.loadHit(this.bufferIndex + i);
        }
    }

    protected abstract E loadHit(int var1);
}

