/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.NullFilteringResultIterator;
import org.infinispan.query.impl.QueryDefinition;

public class CacheQueryImpl<E>
implements IndexedQuery<E> {
    private static final FetchOptions DEFAULT_FETCH_OPTIONS = new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER);
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected QueryDefinition queryDefinition;

    public CacheQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache) {
        this.queryDefinition = queryDefinition;
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
    }

    public CacheQueryImpl(SearchQueryBuilder searchQuery, AdvancedCache<?, ?> cache) {
        this(new QueryDefinition(searchQuery), cache);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        return Math.toIntExact(this.queryDefinition.getSearchQuery().build().fetchTotalHitCount());
    }

    @Override
    public IndexedQuery<E> firstResult(int firstResult) {
        this.queryDefinition.setFirstResult(firstResult);
        return this;
    }

    @Override
    public IndexedQuery<E> maxResults(int maxResults) {
        this.queryDefinition.setMaxResults(maxResults);
        return this;
    }

    @Override
    public ResultIterator<E> iterator() throws SearchException {
        return this.iterator(DEFAULT_FETCH_OPTIONS);
    }

    @Override
    public ResultIterator<E> iterator(FetchOptions fetchOptions) throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQuery().build();
        List queryHits = searchQuery.fetchHits(Integer.valueOf(this.queryDefinition.getFirstResult()), Integer.valueOf(this.queryDefinition.getMaxResults()));
        return this.filterNulls(new EagerIterator(queryHits, fetchOptions.getFetchSize()));
    }

    private ResultIterator<E> filterNulls(ResultIterator<E> iterator) {
        return new NullFilteringResultIterator<E>(iterator);
    }

    @Override
    public List<E> list() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQuery().build();
        List searchResult = searchQuery.fetchHits(Integer.valueOf(this.queryDefinition.getFirstResult()), Integer.valueOf(this.queryDefinition.getMaxResults()));
        return searchResult;
    }

    @Override
    public Explanation explain(String id) {
        LuceneSearchQuery luceneSearchQuery = (LuceneSearchQuery)this.queryDefinition.getSearchQuery().build().extension((SearchQueryExtension)LuceneExtension.get());
        return luceneSearchQuery.explain(id);
    }

    @Override
    public IndexedQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.failAfter(timeout, timeUnit);
        return this;
    }
}

