/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.concurrent.ExecutorService;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.search.mapper.mapping.SearchMappingHolder;

public final class SearchManagerImpl
implements SearchManager {
    private final SearchMappingHolder searchMappingHolder;
    private final QueryInterceptor queryInterceptor;
    private final KeyTransformationHandler keyTransformationHandler;
    private final QueryEngine<?> queryEngine;
    private final MassIndexer massIndexer;

    public SearchManagerImpl(AdvancedCache<?, ?> cache, QueryEngine<?> queryEngine) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.searchMappingHolder = ComponentRegistryUtils.getSearchMappingHolder(cache);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        this.keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler(cache);
        this.queryEngine = queryEngine;
        this.massIndexer = (MassIndexer)((Object)ComponentRegistryUtils.getIndexer(cache));
    }

    public <E> CacheQuery<E> getQuery(SearchQueryBuilder searchQuery) {
        return this.queryEngine.buildCacheQuery(searchQuery);
    }

    @Override
    public <E> CacheQuery<E> getQuery(String queryString, IndexedQueryMode indexedQueryMode) {
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        try {
            return this.queryEngine.buildCacheQuery(queryString, indexedQueryMode, this.keyTransformationHandler, asyncExecutor);
        }
        catch (SearchException se) {
            throw new SearchException("'" + queryString + "' cannot be converted to an indexed query", (Throwable)se);
        }
    }

    @Override
    public <E> CacheQuery<E> getQuery(String queryString) {
        return this.getQuery(queryString, null);
    }

    public <E> CacheQuery<E> getQuery(QueryDefinition queryDefinition, IndexedQueryMode indexedQueryMode) {
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        return this.queryEngine.buildCacheQuery(queryDefinition, indexedQueryMode, asyncExecutor);
    }

    @Override
    public MassIndexer getMassIndexer() {
        return this.massIndexer;
    }

    @Override
    public void purge(Class<?> entityType) {
        this.queryInterceptor.purgeIndex(entityType);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchMappingHolder.class.isAssignableFrom(cls)) {
            return (T)this.searchMappingHolder;
        }
        if (SearchManagerImpl.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Cannot unwrap a SearchManagerImpl into a '" + cls.getName() + "'");
    }
}

