/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.SingleClassDSLQueryTest")
public class SingleClassDSLQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.configureCache(builder);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)builder);
    }

    protected void configureCache(ConfigurationBuilder builder) {
        builder.indexing().enable().addIndexedEntity(Person.class).addProperty("directory.type", "local-heap");
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() {
        this.cache.put((Object)"person1", (Object)new Person("William", "Shakespeare", 50, "ZZ3141592", "M"));
    }

    protected void clearContent() {
    }

    public void testQueryInnerClass() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.create("FROM " + Person.class.getName());
        List matches = query.execute().list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testField() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.create("FROM " + Person.class.getName() + " WHERE driverLicenseId = 'ZZ3141592'");
        List matches = query.execute().list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.create("FROM " + Person.class.getName() + " WHERE age <= 52");
        List matches = query.execute().list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField2() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.create("FROM " + Person.class.getName() + " WHERE name <= 'William'");
        List matches = query.execute().list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField3() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.create("FROM " + Person.class.getName() + " WHERE gender = 'M'");
        List matches = query.execute().list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    public void testInheritedField4() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        Query query = queryFactory.create("FROM " + Person.class.getName() + " WHERE surname = 'Shakespeare'");
        List matches = query.execute().list();
        Assert.assertEquals((int)1, (int)matches.size());
    }

    @Indexed
    public static class Person
    extends PersonBase {
        String driverLicenseId;
        String gender;

        public Person(String name, String surname, int age, String driverLicenseId, String gender) {
            super(name, surname, age);
            this.driverLicenseId = driverLicenseId;
            this.gender = gender;
        }

        @Field(analyze=Analyze.NO)
        public String getDriverLicenseId() {
            return this.driverLicenseId;
        }

        @Override
        @Field(analyze=Analyze.NO)
        public String getGender() {
            return this.gender;
        }
    }

    public static abstract class PersonBase
    implements PersonInterface {
        String name;
        String surname;
        int age;

        PersonBase(String name, String surname, int age) {
            this.name = name;
            this.surname = surname;
            this.age = age;
        }

        @Override
        @Field(analyze=Analyze.NO)
        public String getName() {
            return this.name;
        }

        @Field(analyze=Analyze.NO)
        public String getSurname() {
            return this.surname;
        }

        @Field(analyze=Analyze.NO)
        public int getAge() {
            return this.age;
        }
    }

    static interface PersonInterface {
        public String getName();

        public String getGender();
    }
}

