/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.infinispan.Cache;
import org.infinispan.query.helper.IndexAccessor;
import org.testng.AssertJUnit;

public class StaticTestingErrorHandler
implements FailureHandler {
    private final AtomicReference faulty = new AtomicReference();

    public void handle(FailureContext context) {
        this.faulty.compareAndSet(null, new ThrowableWrapper(context.getFailingOperation().toString(), context.getThrowable()));
    }

    public void handle(EntityIndexingFailureContext context) {
        this.faulty.compareAndSet(null, new ThrowableWrapper(context.getFailingOperation().toString(), context.getThrowable()));
    }

    private Object getAndReset() {
        return this.faulty.getAndSet(null);
    }

    public static void assertAllGood(Cache cache) {
        StaticTestingErrorHandler instance = StaticTestingErrorHandler.extract(cache);
        instance.assertNoErrors();
    }

    public static void assertAllGood(Cache ... caches) {
        for (Cache cache : caches) {
            StaticTestingErrorHandler.assertAllGood(cache);
        }
    }

    private void assertNoErrors() {
        Object fault = this.getAndReset();
        if (fault != null) {
            AssertJUnit.fail((String)fault.toString());
        }
    }

    public static StaticTestingErrorHandler extract(Cache cache) {
        FailureHandler failureHandler = IndexAccessor.extractFailureHandler(cache);
        AssertJUnit.assertTrue((boolean)(failureHandler instanceof StaticTestingErrorHandler));
        return (StaticTestingErrorHandler)failureHandler;
    }

    public static class ThrowableWrapper {
        private final String errorMsg;
        private final Throwable exception;

        public ThrowableWrapper(String errorMsg, Throwable exception) {
            this.errorMsg = errorMsg;
            this.exception = exception;
        }

        public String toString() {
            StringWriter w = new StringWriter();
            w.append(String.valueOf(this.errorMsg));
            if (this.exception != null) {
                w.append(' ');
                this.exception.printStackTrace(new PrintWriter(w));
            }
            return w.toString();
        }
    }
}

