/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.timeout;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;

class TestHelper {
    TestHelper() {
    }

    static void runFullTextQueryWithTimeout(Cache<?, ?> cache, long timeout, TimeUnit timeUnit) {
        QueryFactory queryFactory = Search.getQueryFactory(cache);
        String q = String.format("FROM %s WHERE name:'1'", Person.class.getName());
        Query query = queryFactory.create(q).timeout(timeout, timeUnit);
        query.execute();
    }

    static void runRegularQueryWithTimeout(Cache<?, ?> cache, long timeout, TimeUnit timeUnit) {
        QueryFactory queryFactory = Search.getQueryFactory(cache);
        String q = String.format("FROM %s", Person.class.getName());
        Query query = queryFactory.create(q).timeout(timeout, timeUnit);
        query.execute();
    }

    static void runRegularSortedQueryWithTimeout(Cache<?, ?> cache, long timeout, TimeUnit timeUnit) {
        QueryFactory queryFactory = Search.getQueryFactory(cache);
        String q = String.format("FROM %s ORDER BY name", Person.class.getName());
        Query query = queryFactory.create(q).timeout(timeout, timeUnit);
        query.execute();
    }

    static void populate(Cache cache, int numEntries) {
        for (int i = 0; i < numEntries; ++i) {
            cache.put((Object)i, (Object)new Person(String.valueOf(i), "", 0));
        }
    }
}

