/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import java.io.Serializable;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

@Indexed(index="indexA")
public class TestEntity
implements Serializable {
    private String name;
    private String surname;
    private long id;
    private String note;

    public TestEntity(TestEntity e) {
        this.id = e.getId();
        this.name = e.getName();
        this.surname = e.getSurname();
        this.note = e.getNote();
    }

    @ProtoFactory
    public TestEntity(String name, String surname, long id, String note) {
        this.name = name;
        this.surname = surname;
        this.id = id;
        this.note = note;
    }

    @Field(store=Store.YES, analyze=Analyze.NO)
    @ProtoField(number=1)
    public String getName() {
        return this.name;
    }

    @Field(store=Store.YES)
    @ProtoField(number=2)
    public String getSurname() {
        return this.surname;
    }

    @ProtoField(number=3, defaultValue="0")
    public long getId() {
        return this.id;
    }

    @ProtoField(number=4)
    public String getNote() {
        return this.note;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestEntity that = (TestEntity)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        return !(this.surname != null ? !this.surname.equals(that.surname) : that.surname != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.surname != null ? this.surname.hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.note != null ? this.note.hashCode() : 0);
        return result;
    }
}

