/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.helper.SearchMappingHelper;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HibernateSearchPropertyHelperTest {
    private SearchMapping searchMapping;
    private HibernateSearchPropertyHelper propertyHelper;

    @Before
    public void setup() {
        this.searchMapping = SearchMappingHelper.createSearchMappingForTests(TestEntity.class);
        this.propertyHelper = new HibernateSearchPropertyHelper(this.searchMapping, (EntityNameResolver)new ReflectionEntityNamesResolver(null));
    }

    @After
    public void cleanUp() {
        if (this.searchMapping != null) {
            this.searchMapping.close();
        }
    }

    private Object convertToPropertyType(Class<?> type, String propertyName, String value) {
        return this.propertyHelper.convertToPropertyType(type, new String[]{propertyName}, value);
    }

    @Test
    public void testConvertIdProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "id", "42")).isEqualTo((Object)"42");
    }

    @Test
    public void testConvertStringProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "name", "42")).isEqualTo((Object)"42");
    }

    @Test
    public void testConvertIntProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "i", "42")).isEqualTo((Object)42);
    }

    @Test
    public void testConvertLongProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "l", "42")).isEqualTo((Object)42L);
    }

    @Test
    public void testConvertFloatProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "f", "42.0")).isEqualTo((Object)Float.valueOf(42.0f));
    }

    @Test
    public void testConvertDoubleProperty() {
        Assertions.assertThat((Object)this.convertToPropertyType(TestEntity.class, "d", "42.0")).isEqualTo((Object)42.0);
    }

    @Test
    public void testRecognizeAnalyzedField() {
        Assertions.assertThat((boolean)this.propertyHelper.getIndexedFieldProvider().get(TestEntity.class).isAnalyzed(new String[]{"description"})).isTrue();
    }

    @Test
    public void testRecognizeUnanalyzedField() {
        Assertions.assertThat((boolean)this.propertyHelper.getIndexedFieldProvider().get(TestEntity.class).isAnalyzed(new String[]{"i"})).isFalse();
    }

    @Indexed
    public static class TestEntity {
        public String id;
        public String name;
        public String description;
        public int i;
        public long l;
        public float f;
        public double d;

        @DocumentId
        public String getId() {
            return this.id;
        }

        @Field(analyze=Analyze.NO)
        public String getName() {
            return this.name;
        }

        @Field(analyze=Analyze.YES)
        public String getDescription() {
            return this.description;
        }

        @Field(analyze=Analyze.NO)
        public int getI() {
            return this.i;
        }

        @Field(analyze=Analyze.NO)
        public long getL() {
            return this.l;
        }

        @Field(analyze=Analyze.NO)
        public float getF() {
            return this.f;
        }

        @Field(analyze=Analyze.NO)
        public double getD() {
            return this.d;
        }
    }
}

