/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TwoPhaseCommitIndexingTest")
public class TwoPhaseCommitIndexingTest
extends SingleCacheManagerTest {
    private final AtomicBoolean injectFailures = new AtomicBoolean();
    private final BlowUpInterceptor nastyInterceptor = new BlowUpInterceptor(this.injectFailures);

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.customInterceptors().addInterceptor().after(EntryWrappingInterceptor.class).interceptor((AsyncInterceptor)this.nastyInterceptor).transaction().transactionMode(TransactionMode.TRANSACTIONAL).use1PcForAutoCommitTransactions(false).indexing().enable().addIndexedEntity(Person.class).addProperty("directory.type", "local-heap").locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    public void testQueryAfterAddingNewNode() throws Exception {
        this.store("Astronaut", new Person("Astronaut", "is asking his timezone", 32), true);
        this.assertFind("timezone", 0);
        this.assertFind("asking", 0);
        this.assertFind("cat", 0);
        this.store("Astronaut", new Person("Astronaut", "is asking his timezone", 32), false);
        this.assertFind("timezone", 1);
        this.assertFind("asking", 1);
        this.assertFind("cat", 0);
    }

    private void assertFind(String keyword, int expectedCount) {
        TwoPhaseCommitIndexingTest.assertFind(this.cache, keyword, expectedCount);
    }

    private static void assertFind(Cache cache, String keyword, int expectedCount) {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)cache);
        String q = String.format("FROM %s WHERE blurb:'%s'", Person.class.getName(), keyword);
        Query cacheQuery = queryFactory.create(q);
        long resultSize = cacheQuery.execute().hitCount().orElse(-1L);
        Assert.assertEquals((long)resultSize, (long)expectedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(String key, Object value, boolean failTheOperation) {
        if (failTheOperation) {
            this.injectFailures.set(true);
            try {
                this.cache.put((Object)key, value);
                Assert.fail((String)"Should have failed the implicit transaction");
            }
            catch (Exception exception) {
            }
            finally {
                this.injectFailures.set(false);
            }
        } else {
            this.cache.put((Object)key, value);
        }
    }

    static class BlowUpInterceptor
    extends DDAsyncInterceptor {
        private final AtomicBoolean injectFailures;

        public BlowUpInterceptor(AtomicBoolean injectFailures) {
            this.injectFailures = injectFailures;
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            if (this.injectFailures.get()) {
                throw new SearchException("Test");
            }
            return super.visitPrepareCommand(ctx, command);
        }
    }
}

