/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.File;
import java.nio.file.Paths;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.blackbox.ClusteredCacheTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredCacheFSDirectoryTest")
public class ClusteredCacheFSDirectoryTest
extends ClusteredCacheTest {
    private final String TMP_DIR = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @Override
    protected void createCacheManagers() {
        this.addClusterEnabledCacheManager(QueryTestSCI.INSTANCE, this.buildCacheConfig("index1"));
        this.addClusterEnabledCacheManager(QueryTestSCI.INSTANCE, this.buildCacheConfig("index2"));
        this.waitForClusterToForm();
        this.cache1 = this.cache(0);
        this.cache2 = this.cache(1);
    }

    private ConfigurationBuilder buildCacheConfig(String indexName) {
        ConfigurationBuilder cb = ClusteredCacheFSDirectoryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        cb.indexing().enable().addIndexedEntity(Person.class).addKeyTransformer(CustomKey3.class, CustomKey3Transformer.class).addProperty("directory.type", "local-filesystem").addProperty("directory.root", Paths.get(this.TMP_DIR, indexName).toString()).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        return cb;
    }

    @BeforeClass
    protected void setUpTempDir() {
        Util.recursiveFileRemove((String)this.TMP_DIR);
        boolean created = new File(this.TMP_DIR).mkdirs();
        AssertJUnit.assertTrue((boolean)created);
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        try {
            super.clearContent();
        }
        finally {
            Util.recursiveFileRemove((String)this.TMP_DIR);
        }
    }
}

