/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.blackbox.LocalCacheTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.blackbox.LocalCacheStorageTypeTest")
public class LocalCacheStorageTypeTest
extends LocalCacheTest {
    protected StorageType storageType;

    protected String parameters() {
        return "[" + this.storageType + "]";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new LocalCacheStorageTypeTest().withStorageType(StorageType.OFF_HEAP), new LocalCacheStorageTypeTest().withStorageType(StorageType.BINARY), new LocalCacheStorageTypeTest().withStorageType(StorageType.OBJECT)};
    }

    LocalCacheStorageTypeTest withStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addKeyTransformer(CustomKey3.class, CustomKey3Transformer.class).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("directory.type", "local-heap").addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        cfg.memory().storageType(this.storageType);
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }
}

