/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.QueryTestSCI;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DistProgrammaticMassIndexTest")
public class DistProgrammaticMassIndexTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(holder -> {
            String defaultName = ((Object)((Object)this)).getClass().getSimpleName();
            holder.getGlobalConfigurationBuilder().defaultCacheName(defaultName).serialization().addContextInitializer((SerializationContextInitializer)QueryTestSCI.INSTANCE);
            ConfigurationBuilder cacheCfg = DistProgrammaticMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
            cacheCfg.indexing().enable().addIndexedEntity(Car.class).addProperty("directory.type", "local-heap").addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
            cacheCfg.clustering().stateTransfer().fetchInMemoryState(true);
            holder.newConfigurationBuilder(defaultName).read(cacheCfg.build());
        }, 3);
    }

    protected void verifyFindsCar(Cache cache, int count, String carMake) {
        String q = String.format("FROM %s where make:'%s'", Car.class.getName(), carMake);
        Query cacheQuery = Search.getQueryFactory((Cache)cache).create(q);
        AssertJUnit.assertEquals((long)count, (long)cacheQuery.execute().hitCount().orElse(-1L));
        StaticTestingErrorHandler.assertAllGood(cache);
    }
}

