/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.IndexedQueryImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.remoting.transport.Address;

public final class DistributedIndexedQueryImpl<E>
extends IndexedQueryImpl<E> {
    private Integer resultSize;
    private final ClusteredQueryInvoker invoker;
    private int maxResults = 100;
    private int firstResult = 0;

    public DistributedIndexedQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache) {
        super(queryDefinition, cache);
        this.invoker = new ClusteredQueryInvoker(cache);
    }

    @Override
    public IndexedQuery<E> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return super.maxResults(maxResults);
    }

    @Override
    public IndexedQuery<E> firstResult(int firstResult) {
        this.firstResult = firstResult;
        return super.firstResult(firstResult);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        if (this.resultSize == null) {
            List<QueryResponse> responses = this.invoker.broadcast(ClusteredQueryOperation.getResultSize(this.queryDefinition));
            int accumulator = 0;
            for (QueryResponse response : responses) {
                accumulator += response.getResultSize().intValue();
            }
            this.resultSize = accumulator;
        }
        return Math.toIntExact(this.resultSize.intValue());
    }

    @Override
    public CloseableIterator<E> iterator() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        this.queryDefinition.setMaxResults(this.getNodeMaxResults());
        ClusteredQueryOperation command = ClusteredQueryOperation.createEagerIterator(this.queryDefinition);
        Map<Address, NodeTopDocs> topDocsResponses = this.broadcastQuery(command);
        return new DistributedIterator(this.queryDefinition.getSearchQuery().getLuceneSort(), this.maxResults, this.resultSize, this.maxResults, this.firstResult, topDocsResponses, this.cache);
    }

    private int getNodeMaxResults() {
        return this.maxResults + this.firstResult;
    }

    private Map<Address, NodeTopDocs> broadcastQuery(ClusteredQueryOperation command) {
        HashMap<Address, NodeTopDocs> topDocsResponses = new HashMap<Address, NodeTopDocs>();
        int resultSize = 0;
        List<QueryResponse> responses = this.invoker.broadcast(command);
        for (QueryResponse queryResponse : responses) {
            if (queryResponse.getResultSize() <= 0) continue;
            topDocsResponses.put(queryResponse.getNodeTopDocs().address, queryResponse.getNodeTopDocs());
            resultSize += queryResponse.getResultSize().intValue();
        }
        this.resultSize = resultSize;
        return topDocsResponses;
    }

    @Override
    public List<E> list() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        ArrayList<Object> values = new ArrayList<Object>();
        try (CloseableIterator<E> iterator = this.iterator();){
            while (iterator.hasNext()) {
                values.add(iterator.next());
            }
        }
        return values;
    }

    @Override
    public IndexedQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.setTimeout(timeout, timeUnit);
        return this;
    }
}

