/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.ExistsPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateBoostStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.FieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.CompositeSortComponentsStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.SearchProjectionInfo;
import org.infinispan.query.dsl.embedded.impl.SearchQueryParsingResult;
import org.infinispan.query.logging.Log;
import org.infinispan.search.mapper.common.EntityReference;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;
import org.jboss.logging.Logger;

public final class SearchQueryMaker<TypeMetadata>
implements Visitor<PredicateFinalStep, PredicateFinalStep> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)SearchQueryMaker.class.getName());
    private static final char LUCENE_SINGLE_CHARACTER_WILDCARD = '?';
    private static final char LUCENE_MULTIPLE_CHARACTERS_WILDCARD = '*';
    private static final char LUCENE_WILDCARD_ESCAPE_CHARACTER = '\\';
    private final SearchMapping searchMapping;
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    private Map<String, Object> namedParameters;
    private LuceneSearchPredicateFactory predicateFactory;
    private SearchIndexedEntity indexedEntity;

    SearchQueryMaker(SearchMapping searchMapping, ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.searchMapping = searchMapping;
        this.propertyHelper = propertyHelper;
    }

    public SearchQueryParsingResult transform(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, Class<?> targetedType, String targetedNamedType) {
        if (this.searchMapping == null) {
            throw log.noTypeIsIndexed(parsingResult.getQueryString());
        }
        this.namedParameters = namedParameters;
        SearchSession querySession = this.searchMapping.getMappingSession();
        SearchScope scope = targetedNamedType == null ? querySession.scope(targetedType) : querySession.scope(targetedType, targetedNamedType);
        this.predicateFactory = (LuceneSearchPredicateFactory)scope.predicate().extension((SearchPredicateFactoryExtension)LuceneExtension.get());
        this.indexedEntity = targetedNamedType == null ? this.searchMapping.indexedEntity(targetedType) : this.searchMapping.indexedEntity(targetedNamedType);
        SearchPredicate predicate = this.makePredicate(parsingResult.getWhereClause()).toPredicate();
        SearchProjectionInfo projection = this.makeProjection(parsingResult.getTargetEntityMetadata(), scope.projection(), parsingResult.getProjections(), parsingResult.getProjectedTypes());
        SearchSort sort = this.makeSort(scope.sort(), parsingResult.getSortFields());
        return new SearchQueryParsingResult(targetedType, targetedNamedType, projection, predicate, sort);
    }

    private SearchProjectionInfo makeProjection(TypeMetadata typeMetadata, SearchProjectionFactory<EntityReference, ?> projectionFactory, String[] projections, Class<?>[] projectedTypes) {
        if (projections == null || projections.length == 0) {
            return SearchProjectionInfo.entity(projectionFactory);
        }
        if (projections.length == 1) {
            if (HibernateSearchPropertyHelper.VALUE.equals(projections[0])) {
                return SearchProjectionInfo.entity(projectionFactory);
            }
            if (HibernateSearchPropertyHelper.KEY.equals(projections[0])) {
                return SearchProjectionInfo.entityReference(projectionFactory);
            }
            boolean isRepeatedProperty = this.propertyHelper.isRepeatedProperty(typeMetadata, FieldPaths.split((String)projections[0]));
            if (isRepeatedProperty) {
                return SearchProjectionInfo.multiField(projectionFactory, projections[0], projectedTypes[0]);
            }
            return SearchProjectionInfo.field(projectionFactory, projections[0], projectedTypes[0]);
        }
        SearchProjection[] searchProjections = new SearchProjection[projections.length];
        for (int i = 0; i < projections.length; ++i) {
            if (HibernateSearchPropertyHelper.VALUE.equals(projections[i])) {
                searchProjections[i] = projectionFactory.entity().toProjection();
                continue;
            }
            if (HibernateSearchPropertyHelper.KEY.equals(projections[i])) {
                searchProjections[i] = projectionFactory.entityReference().toProjection();
                continue;
            }
            boolean isMultiField = this.propertyHelper.isRepeatedProperty(typeMetadata, FieldPaths.split((String)projections[i]));
            FieldProjectionValueStep projectionStep = projectionFactory.field(projections[i], projectedTypes[i]);
            searchProjections[i] = isMultiField ? projectionStep.multi().toProjection() : projectionStep.toProjection();
        }
        return SearchProjectionInfo.composite(projectionFactory, searchProjections);
    }

    private SearchSort makeSort(SearchSortFactory sortFactory, SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return sortFactory.score().toSort();
        }
        if (sortFields.length == 1) {
            return this.makeSort(sortFactory, sortFields[0]);
        }
        CompositeSortComponentsStep composite = sortFactory.composite();
        for (SortField sortField : sortFields) {
            composite.add(this.makeSort(sortFactory, sortField));
        }
        return composite.toSort();
    }

    private SearchSort makeSort(SearchSortFactory sortFactory, SortField sortField) {
        FieldSortOptionsStep optionsStep = sortFactory.field(sortField.getPath().asStringPathWithoutAlias());
        if (sortField.isAscending()) {
            optionsStep.asc();
        } else {
            optionsStep.desc();
        }
        return optionsStep.toSort();
    }

    private PredicateFinalStep makePredicate(BooleanExpr expr) {
        return expr == null ? this.predicateFactory.matchAll() : (PredicateFinalStep)expr.acceptVisitor((Visitor)this);
    }

    public PredicateFinalStep visit(FullTextOccurExpr fullTextOccurExpr) {
        PredicateFinalStep childPredicate = (PredicateFinalStep)fullTextOccurExpr.getChild().acceptVisitor((Visitor)this);
        switch (fullTextOccurExpr.getOccur()) {
            case SHOULD: {
                return this.predicateFactory.bool().should(childPredicate);
            }
            case MUST: 
            case FILTER: {
                return this.predicateFactory.bool().must(childPredicate);
            }
            case MUST_NOT: {
                return this.predicateFactory.bool().mustNot(childPredicate);
            }
        }
        throw new IllegalArgumentException("Unknown boolean occur clause: " + fullTextOccurExpr.getOccur());
    }

    public PredicateFinalStep visit(FullTextBoostExpr fullTextBoostExpr) {
        BooleanExpr child = fullTextBoostExpr.getChild();
        float boost = fullTextBoostExpr.getBoost();
        if (child instanceof FullTextRegexpExpr) {
            FullTextRegexpExpr fullTextRegexpExpr = (FullTextRegexpExpr)child;
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRegexpExpr.getChild();
            String regexp = fullTextRegexpExpr.getRegexp();
            RegexpQuery nativeRegexQuery = new RegexpQuery(new Term(propertyValueExpr.getPropertyPath().asStringPath(), regexp));
            BoostQuery nativeQuery = new BoostQuery((Query)nativeRegexQuery, fullTextBoostExpr.getBoost());
            return this.predicateFactory.fromLuceneQuery((Query)nativeQuery);
        }
        PredicateFinalStep childPredicate = (PredicateFinalStep)child.acceptVisitor((Visitor)this);
        if (childPredicate instanceof PredicateBoostStep) {
            ((PredicateBoostStep)childPredicate).boost(boost);
        }
        return childPredicate;
    }

    private boolean isMultiTermText(PropertyPath<?> propertyPath, String text) {
        Analyzer analyzer = this.getAnalyzer(propertyPath);
        if (analyzer == null) {
            analyzer = new WhitespaceAnalyzer();
        }
        int terms = 0;
        try (TokenStream tokenStream = analyzer.tokenStream(propertyPath.asStringPathWithoutAlias(), (Reader)new StringReader(text));){
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken() && (posIncAtt.getPositionIncrement() <= 0 || ++terms <= 1)) {
            }
            tokenStream.end();
        }
        catch (IOException e) {
            log.error(e);
        }
        return terms > 1;
    }

    private Analyzer getAnalyzer(PropertyPath<?> propertyPath) {
        Optional indexFieldDescriptor = this.indexedEntity.indexManager().descriptor().field(propertyPath.asStringPath());
        if (!indexFieldDescriptor.isPresent()) {
            return null;
        }
        IndexFieldDescriptor fieldDescriptor = (IndexFieldDescriptor)indexFieldDescriptor.get();
        if (fieldDescriptor.isObjectField()) {
            return null;
        }
        IndexValueFieldDescriptor valueField = fieldDescriptor.toValueField();
        Optional analyzerName = valueField.type().analyzerName();
        if (!analyzerName.isPresent()) {
            return null;
        }
        LuceneBackend luceneBackend = (LuceneBackend)this.indexedEntity.indexManager().backend().unwrap(LuceneBackend.class);
        Optional analyzer = luceneBackend.analyzer((String)analyzerName.get());
        if (!analyzer.isPresent()) {
            return null;
        }
        return (Analyzer)analyzer.get();
    }

    public PredicateFinalStep visit(FullTextTermExpr fullTextTermExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextTermExpr.getChild();
        String text = fullTextTermExpr.getTerm();
        String absoluteFieldPath = propertyValueExpr.getPropertyPath().asStringPath();
        int asteriskPos = text.indexOf(42);
        int questionPos = text.indexOf(63);
        if (asteriskPos == -1 && questionPos == -1) {
            if (this.isMultiTermText(propertyValueExpr.getPropertyPath(), text)) {
                PhrasePredicateOptionsStep result = this.predicateFactory.phrase().field(absoluteFieldPath).matching(text);
                if (fullTextTermExpr.getFuzzySlop() != null) {
                    result.slop(fullTextTermExpr.getFuzzySlop().intValue());
                }
                return result;
            }
            MatchPredicateOptionsStep result = this.predicateFactory.match().field(absoluteFieldPath).matching((Object)text);
            if (fullTextTermExpr.getFuzzySlop() != null) {
                result.fuzzy(fullTextTermExpr.getFuzzySlop().intValue());
            }
            return result;
        }
        if (fullTextTermExpr.getFuzzySlop() != null) {
            throw Log.CONTAINER.getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(fullTextTermExpr.toQueryString());
        }
        if (questionPos == -1 && asteriskPos == text.length() - 1) {
            return this.predicateFactory.simpleQueryString().field(absoluteFieldPath).matching(text).flags(new SimpleQueryFlag[]{SimpleQueryFlag.PREFIX});
        }
        return this.predicateFactory.wildcard().field(absoluteFieldPath).matching(text);
    }

    public PredicateFinalStep visit(FullTextRegexpExpr fullTextRegexpExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRegexpExpr.getChild();
        String regexp = fullTextRegexpExpr.getRegexp();
        RegexpQuery nativeQuery = new RegexpQuery(new Term(propertyValueExpr.getPropertyPath().asStringPath(), regexp));
        return this.predicateFactory.fromLuceneQuery((Query)nativeQuery);
    }

    public PredicateFinalStep visit(FullTextRangeExpr fullTextRangeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRangeExpr.getChild();
        String absoluteFieldPath = propertyValueExpr.getPropertyPath().asStringPath();
        Object lower = fullTextRangeExpr.getLower();
        Object upper = fullTextRangeExpr.getUpper();
        boolean includeLower = fullTextRangeExpr.isIncludeLower();
        boolean includeUpper = fullTextRangeExpr.isIncludeUpper();
        if (lower == null && upper == null) {
            return this.predicateFactory.exists().field(absoluteFieldPath);
        }
        RangePredicateFieldMoreStep range = this.predicateFactory.range().field(absoluteFieldPath);
        return range.between(lower, includeLower ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED, upper, includeUpper ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED);
    }

    public PredicateFinalStep visit(NotExpr notExpr) {
        BooleanExpr childExpr = notExpr.getChild();
        if (childExpr instanceof IsNullExpr) {
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)((IsNullExpr)childExpr).getChild();
            return this.predicateFactory.exists().field(propertyValueExpr.getPropertyPath().asStringPath());
        }
        PredicateFinalStep childPredicate = (PredicateFinalStep)childExpr.acceptVisitor((Visitor)this);
        return this.predicateFactory.bool().mustNot(childPredicate);
    }

    public PredicateFinalStep visit(OrExpr orExpr) {
        BooleanPredicateClausesStep bool = this.predicateFactory.bool();
        for (BooleanExpr c : orExpr.getChildren()) {
            PredicateFinalStep clause = (PredicateFinalStep)c.acceptVisitor((Visitor)this);
            bool.should(clause);
        }
        return bool;
    }

    public PredicateFinalStep visit(AndExpr andExpr) {
        BooleanPredicateClausesStep bool = this.predicateFactory.bool();
        for (BooleanExpr c : andExpr.getChildren()) {
            PredicateFinalStep clause = (PredicateFinalStep)c.acceptVisitor((Visitor)this);
            bool.must(clause);
        }
        return bool;
    }

    public PredicateFinalStep visit(IsNullExpr isNullExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)isNullExpr.getChild();
        ExistsPredicateOptionsStep exists = this.predicateFactory.exists().field(propertyValueExpr.getPropertyPath().asStringPath());
        return this.predicateFactory.bool().mustNot((PredicateFinalStep)exists);
    }

    public PredicateFinalStep visit(ComparisonExpr comparisonExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)comparisonExpr.getLeftChild();
        ConstantValueExpr constantValueExpr = (ConstantValueExpr)comparisonExpr.getRightChild();
        Comparable value = constantValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        switch (comparisonExpr.getComparisonType()) {
            case NOT_EQUAL: {
                return this.predicateFactory.bool().mustNot(c -> c.match().field(path).matching((Object)value));
            }
            case EQUAL: {
                return this.predicateFactory.match().field(path).matching((Object)value);
            }
            case LESS: {
                return this.predicateFactory.range().field(path).lessThan((Object)value);
            }
            case LESS_OR_EQUAL: {
                return this.predicateFactory.range().field(path).atMost((Object)value);
            }
            case GREATER: {
                return this.predicateFactory.range().field(path).greaterThan((Object)value);
            }
            case GREATER_OR_EQUAL: {
                return this.predicateFactory.range().field(path).atLeast((Object)value);
            }
        }
        throw new IllegalStateException("Unexpected comparison type: " + comparisonExpr.getComparisonType());
    }

    public PredicateFinalStep visit(BetweenExpr betweenExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)betweenExpr.getLeftChild();
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        ConstantValueExpr fromValueExpr = (ConstantValueExpr)betweenExpr.getFromChild();
        ConstantValueExpr toValueExpr = (ConstantValueExpr)betweenExpr.getToChild();
        Comparable fromValue = fromValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        Comparable toValue = toValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        return this.predicateFactory.range().field(path).between((Object)fromValue, (Object)toValue);
    }

    public PredicateFinalStep visit(LikeExpr likeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)likeExpr.getChild();
        StringBuilder lucenePattern = new StringBuilder(likeExpr.getPattern(this.namedParameters));
        boolean isEscaped = false;
        for (int i = 0; i < lucenePattern.length(); ++i) {
            char c = lucenePattern.charAt(i);
            if (!isEscaped && c == likeExpr.getEscapeChar()) {
                isEscaped = true;
                lucenePattern.deleteCharAt(i);
                continue;
            }
            if (isEscaped) {
                isEscaped = false;
            } else {
                if (c == '%') {
                    lucenePattern.setCharAt(i, '*');
                    continue;
                }
                if (c == '_') {
                    lucenePattern.setCharAt(i, '?');
                    continue;
                }
            }
            if (c != '?' && c != '*') continue;
            lucenePattern.insert(i, '\\');
            ++i;
        }
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        return this.predicateFactory.wildcard().field(path).matching(lucenePattern.toString());
    }

    public PredicateFinalStep visit(ConstantBooleanExpr constantBooleanExpr) {
        return constantBooleanExpr.getValue() ? this.predicateFactory.matchAll() : this.predicateFactory.bool().mustNot((PredicateFinalStep)this.predicateFactory.matchAll());
    }

    public PredicateFinalStep visit(ConstantValueExpr constantValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public PredicateFinalStep visit(PropertyValueExpr propertyValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public PredicateFinalStep visit(AggregationExpr aggregationExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }
}

