/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.core.impl.EmbeddedQueryFactory;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.DslSCI;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.dsl.embedded.testdomain.Transaction;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.dsl.embedded.QueryDslConditionsTest")
public class QueryDslConditionsTest
extends AbstractQueryDslTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().addIndexedEntity(this.getModelFactory().getUserImplClass()).addIndexedEntity(this.getModelFactory().getAccountImplClass()).addIndexedEntity(this.getModelFactory().getTransactionImplClass()).addProperty("directory.type", "local-heap");
        this.createClusteredCaches(1, DslSCI.INSTANCE, cfg);
    }

    protected boolean testNullCollections() {
        return true;
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() throws Exception {
        User user1 = this.getModelFactory().makeUser();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        user1.setCreationDate(Instant.parse("2011-12-03T10:15:30Z"));
        user1.setPasswordExpirationDate(Instant.parse("2011-12-03T10:15:30Z"));
        Address address1 = this.getModelFactory().makeAddress();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        address1.setNumber(156);
        user1.setAddresses(Collections.singletonList(address1));
        User user2 = this.getModelFactory().makeUser();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setSalutation("Mr.");
        user2.setGender(User.Gender.MALE);
        user2.setAccountIds(Collections.singleton(3));
        user2.setCreationDate(Instant.parse("2011-12-03T10:15:30Z"));
        user2.setPasswordExpirationDate(Instant.parse("2011-12-03T10:15:30Z"));
        Address address2 = this.getModelFactory().makeAddress();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        address2.setNumber(-12);
        Address address3 = this.getModelFactory().makeAddress();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        address3.setNumber(312);
        user2.setAddresses(Arrays.asList(address2, address3));
        User user3 = this.getModelFactory().makeUser();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setSalutation("Ms.");
        user3.setGender(User.Gender.FEMALE);
        user3.setAccountIds(Collections.emptySet());
        user3.setCreationDate(Instant.parse("2011-12-03T10:15:30Z"));
        user3.setPasswordExpirationDate(Instant.parse("2011-12-03T10:15:30Z"));
        if (!this.testNullCollections()) {
            user3.setAddresses(new ArrayList<Address>());
        }
        Account account1 = this.getModelFactory().makeAccount();
        account1.setId(1);
        account1.setDescription("John Doe's first bank account");
        account1.setCreationDate(this.makeDate("2013-01-03"));
        Account account2 = this.getModelFactory().makeAccount();
        account2.setId(2);
        account2.setDescription("John Doe's second bank account");
        account2.setCreationDate(this.makeDate("2013-01-04"));
        Account account3 = this.getModelFactory().makeAccount();
        account3.setId(3);
        account3.setCreationDate(this.makeDate("2013-01-20"));
        Transaction transaction0 = this.getModelFactory().makeTransaction();
        transaction0.setId(0);
        transaction0.setDescription("Birthday present");
        transaction0.setAccountId(1);
        transaction0.setAmount(1800.0);
        transaction0.setDate(this.makeDate("2012-09-07"));
        transaction0.setDebit(false);
        transaction0.setValid(true);
        Transaction transaction1 = this.getModelFactory().makeTransaction();
        transaction1.setId(1);
        transaction1.setDescription("Feb. rent payment");
        transaction1.setLongDescription("Feb. rent payment");
        transaction1.setAccountId(1);
        transaction1.setAmount(1500.0);
        transaction1.setDate(this.makeDate("2013-01-05"));
        transaction1.setDebit(true);
        transaction1.setValid(true);
        Transaction transaction2 = this.getModelFactory().makeTransaction();
        transaction2.setId(2);
        transaction2.setDescription("Starbucks");
        transaction2.setLongDescription("Starbucks");
        transaction2.setAccountId(1);
        transaction2.setAmount(23.0);
        transaction2.setDate(this.makeDate("2013-01-09"));
        transaction2.setDebit(true);
        transaction2.setValid(true);
        Transaction transaction3 = this.getModelFactory().makeTransaction();
        transaction3.setId(3);
        transaction3.setDescription("Hotel");
        transaction3.setAccountId(2);
        transaction3.setAmount(45.0);
        transaction3.setDate(this.makeDate("2013-02-27"));
        transaction3.setDebit(true);
        transaction3.setValid(true);
        Transaction transaction4 = this.getModelFactory().makeTransaction();
        transaction4.setId(4);
        transaction4.setDescription("Last january");
        transaction4.setLongDescription("Last january");
        transaction4.setAccountId(2);
        transaction4.setAmount(95.0);
        transaction4.setDate(this.makeDate("2013-01-31"));
        transaction4.setDebit(true);
        transaction4.setValid(true);
        Transaction transaction5 = this.getModelFactory().makeTransaction();
        transaction5.setId(5);
        transaction5.setDescription("-Popcorn");
        transaction5.setLongDescription("-Popcorn");
        transaction5.setAccountId(2);
        transaction5.setAmount(5.0);
        transaction5.setDate(this.makeDate("2013-01-01"));
        transaction5.setDebit(true);
        transaction5.setValid(true);
        this.getCacheForWrite().put((Object)("user_" + user1.getId()), (Object)user1);
        this.getCacheForWrite().put((Object)("user_" + user2.getId()), (Object)user2);
        this.getCacheForWrite().put((Object)("user_" + user3.getId()), (Object)user3);
        this.getCacheForWrite().put((Object)("account_" + account1.getId()), (Object)account1);
        this.getCacheForWrite().put((Object)("account_" + account2.getId()), (Object)account2);
        this.getCacheForWrite().put((Object)("account_" + account3.getId()), (Object)account3);
        this.getCacheForWrite().put((Object)("transaction_" + transaction0.getId()), (Object)transaction0);
        this.getCacheForWrite().put((Object)("transaction_" + transaction1.getId()), (Object)transaction1);
        this.getCacheForWrite().put((Object)("transaction_" + transaction2.getId()), (Object)transaction2);
        this.getCacheForWrite().put((Object)("transaction_" + transaction3.getId()), (Object)transaction3);
        this.getCacheForWrite().put((Object)("transaction_" + transaction4.getId()), (Object)transaction4);
        this.getCacheForWrite().put((Object)("transaction_" + transaction5.getId()), (Object)transaction5);
        for (int i = 0; i < 50; ++i) {
            Transaction transaction = this.getModelFactory().makeTransaction();
            transaction.setId(50 + i);
            transaction.setDescription("Expensive shoes " + i);
            transaction.setLongDescription("Expensive shoes " + i);
            transaction.setAccountId(2);
            transaction.setAmount(100 + i);
            transaction.setDate(this.makeDate("2013-08-20"));
            transaction.setDebit(true);
            transaction.setValid(true);
            this.getCacheForWrite().put((Object)("transaction_" + transaction.getId()), (Object)transaction);
        }
        this.getCacheForWrite().put((Object)"dummy", (Object)"a primitive value cannot be queried");
        this.getCacheForWrite().put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.getCacheForWrite().put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    public void testIndexPresence() {
        SearchMapping searchMapping = (SearchMapping)TestingUtil.extractComponent((Cache)((Cache)this.getCacheForQuery()), SearchMapping.class);
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getUserImplClass());
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getAccountImplClass());
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getTransactionImplClass());
        this.verifyClassIsNotIndexed(searchMapping, this.getModelFactory().getAddressImplClass());
    }

    private void verifyClassIsNotIndexed(SearchMapping searchMapping, Class<?> type) {
        AssertionsForInterfaceTypes.assertThat((Map)searchMapping.allIndexedTypes()).doesNotContainValue(type);
    }

    private void verifyClassIsIndexed(SearchMapping searchMapping, Class<?> type) {
        AssertionsForInterfaceTypes.assertThat((Map)searchMapping.allIndexedTypes()).containsValue(type);
    }

    public void testQueryFactoryType() {
        AssertJUnit.assertEquals(EmbeddedQueryFactory.class, this.getQueryFactory().getClass());
    }

    public void testEq1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Doe", (String)((User)list.get(0)).getSurname());
    }

    public void testEqEmptyString() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"").build();
        List list = q.list();
        AssertJUnit.assertTrue((boolean)list.isEmpty());
    }

    public void testEqSentence() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("description").eq((Object)"John Doe's first bank account").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
    }

    public void testEq() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Jacob").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testEqNonIndexedType() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(NotIndexed.class).having("notIndexedField").eq((Object)"testing 123").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }

    public void testEqNonIndexedField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    public void testEqHybridQuery() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet")).and().having("surname").eq((Object)"Doe").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    public void testEqHybridQueryWithParam() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet")).and().having("surname").eq((Object)Expression.param((String)"surnameParam")).build();
        q.setParameter("surnameParam", (Object)"Doe");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    public void testEqHybridQueryWithPredicateOptimisation() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("notes").like("%ipsum%").and((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or().having("name").eq((Object)"Jane")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"Lorem ipsum dolor sit amet", (String)((User)list.get(0)).getNotes());
    }

    public void testEqInNested1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses.postCode").eq((Object)"X1234").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"X1234", (String)((User)list.get(0)).getAddresses().get(0).getPostCode());
    }

    public void testEqInNested2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses.postCode").eq((Object)"Y12").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((User)list.get(0)).getAddresses().size());
    }

    public void testLike() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("description").like("%rent%").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Transaction)list.get(0)).getAccountId());
        AssertJUnit.assertEquals((double)1500.0, (double)((Transaction)list.get(0)).getAmount(), (double)0.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014802: 'from' must be an instance of java.lang.Comparable")
    public void testBetweenArgsAreComparable() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between(new Object(), new Object()).build();
    }

    public void testBetween1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBetween2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).includeUpper(false).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) < 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBetween3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).includeLower(false).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) > 0 ? 1 : 0) != 0);
        }
    }

    public void testGt() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").gt((Object)1500).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertTrue((((Transaction)list.get(0)).getAmount() > 1500.0 ? 1 : 0) != 0);
    }

    public void testGte() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").gte((Object)1500).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getAmount() >= 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLt() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").lt((Object)1500).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)54, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getAmount() < 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLte() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("amount").lte((Object)1500).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)55, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getAmount() <= 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLteOnFieldWithNullToken() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("description").lte((Object)"-Popcorn").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"-Popcorn", (String)((Transaction)list.get(0)).getDescription());
    }

    public void testAnd1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider")).and().having("surname").eq((Object)"Man").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((User)list.get(0)).getId());
    }

    public void testAnd2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider")).and((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((User)list.get(0)).getId());
    }

    public void testAnd3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE)).and().having("gender").eq((Object)User.Gender.FEMALE).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testAnd4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider")).or((FilterConditionContext)qf.having("name").eq((Object)"John")).and((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testOr1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man")).or().having("surname").eq((Object)"Woman").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        for (User u : list) {
            AssertJUnit.assertEquals((String)"Spider", (String)u.getName());
        }
    }

    public void testOr2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man")).or((FilterConditionContext)qf.having("surname").eq((Object)"Woman")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        for (User u : list) {
            AssertJUnit.assertEquals((String)"Spider", (String)u.getName());
        }
    }

    public void testOr3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE)).or().having("gender").eq((Object)User.Gender.FEMALE).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testOr4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)((FilterConditionContext)((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).orderBy("surname", SortOrder.DESC).having("gender").eq((Object)User.Gender.MALE)).or().having("name").eq((Object)"Spider")).and().having("gender").eq((Object)User.Gender.FEMALE)).or().having("surname").like("%oe%").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"Woman", (String)((User)list.get(0)).getSurname());
        AssertJUnit.assertEquals((String)"Doe", (String)((User)list.get(1)).getSurname());
    }

    public void testOr5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)((FilterConditionContext)((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE)).or().having("name").eq((Object)"Spider")).or().having("gender").eq((Object)User.Gender.FEMALE)).and().having("surname").like("%oe%").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
    }

    public void testNot1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"Spider").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
    }

    public void testNot2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().not().having("surname").eq((Object)"Doe").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
    }

    public void testNot3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"John")).and().having("surname").eq((Object)"Man").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
    }

    public void testNot4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man")).and().not().having("name").eq((Object)"John").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
    }

    public void testNot5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"Spider")).or().having("surname").eq((Object)"Man").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        for (User u : list) {
            Assert.assertNotEquals((Object)u.getSurname(), (Object)"Woman");
        }
    }

    public void testNot6() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.not((FilterConditionContext)qf.having("gender").eq((Object)User.Gender.FEMALE))).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"Woman", (String)((User)list.get(0)).getSurname());
    }

    public void testNot7() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.FEMALE)).and().not((FilterConditionContext)qf.having("name").eq((Object)"Spider")).build();
        List list = q.list();
        AssertJUnit.assertTrue((boolean)list.isEmpty());
    }

    public void testNot8() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or((FilterConditionContext)qf.having("surname").eq((Object)"Man"))).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Woman", (String)((User)list.get(0)).getSurname());
    }

    public void testNot9() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).and((FilterConditionContext)qf.having("surname").eq((Object)"Doe"))).orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Man", (String)((User)list.get(0)).getSurname());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(1)).getName());
        AssertJUnit.assertEquals((String)"Woman", (String)((User)list.get(1)).getSurname());
    }

    public void testNot10() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or((FilterConditionContext)qf.having("surname").eq((Object)"Man"))).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        Assert.assertNotEquals((Object)((User)list.get(0)).getSurname(), (Object)"Woman");
    }

    public void testNot11() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not(qf.not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or((FilterConditionContext)qf.having("surname").eq((Object)"Man")))).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        Assert.assertNotEquals((Object)((User)list.get(0)).getSurname(), (Object)"Woman");
    }

    public void testEmptyQuery() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testTautology() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").gt((Object)"A").or().having("name").lte((Object)"A").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testContradiction() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").gt((Object)"A").and().having("name").lte((Object)"A").build();
        List list = q.list();
        AssertJUnit.assertTrue((boolean)list.isEmpty());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028503:.*")
    public void testInvalidEmbeddedAttributeQuery() {
        QueryFactory qf = this.getQueryFactory();
        QueryBuilder queryBuilder = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"addresses"});
        Query q = queryBuilder.build();
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014027: The property path 'addresses.postCode' cannot be projected because it is multi-valued")
    public void testRejectProjectionOfRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"addresses.postCode"}).build();
        q.list();
    }

    public void testIsNull1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("surname").isNull().build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testIsNull2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("surname").isNull().build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testIsNull3() {
        if (this.testNullCollections()) {
            QueryFactory qf = this.getQueryFactory();
            Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses").isNull().build();
            List list = q.list();
            AssertJUnit.assertEquals((int)1, (int)list.size());
            AssertJUnit.assertEquals((int)3, (int)((User)list.get(0)).getId());
        }
    }

    public void testIsNullNumericWithProjection1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name", "surname", "age"}).orderBy("name", SortOrder.ASC).orderBy("surname", SortOrder.ASC).orderBy("age", SortOrder.ASC).having("age").isNull().or().having("age").equal((Object)-1).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Man", (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(0))[2]);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)"Woman", (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(1))[2]);
    }

    public void testIsNullNumericWithProjection2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name", "age"}).not().having("age").isNull().and().not().having("age").equal((Object)-1).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)22, (Object)((Object[])list.get(0))[1]);
    }

    public void testContains1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)2).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    public void testContains2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)42).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testContainsAll1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{1, 2}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    public void testContainsAll2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(Collections.singleton(1)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
    }

    public void testContainsAll3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{1, 2, 3}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testContainsAll4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(Collections.emptySet()).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testContainsAny1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).having("accountIds").containsAny(new Object[]{2, 3}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
        AssertJUnit.assertEquals((int)2, (int)((User)list.get(1)).getId());
    }

    public void testContainsAny2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAny(new Object[]{4, 5}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testContainsAny3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAny(Collections.emptySet()).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testIn1() {
        QueryFactory qf = this.getQueryFactory();
        List<Integer> ids = Arrays.asList(1, 3);
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").in(ids).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        for (User u : list) {
            AssertJUnit.assertTrue((boolean)ids.contains(u.getId()));
        }
    }

    public void testIn2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("id").in(new Object[]{4}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn3() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in(Collections.emptySet());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn4() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in((Collection)null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn5() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in((Object[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn6() {
        QueryFactory qf = this.getQueryFactory();
        Object[] array = new Object[]{};
        qf.from(this.getModelFactory().getUserImplClass()).having("id").in(array);
    }

    public void testSampleDomainQuery1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).having("gender").eq((Object)User.Gender.MALE).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(1)).getName());
    }

    public void testSampleDomainQuery2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).not((FilterConditionContext)qf.having("gender").eq((Object)User.Gender.FEMALE)).and((FilterConditionContext)qf.not().not((FilterConditionContext)qf.having("gender").eq((Object)User.Gender.MALE))).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(1)).getName());
    }

    public void testStringLiteralEscape() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("description").eq((Object)"John Doe's first bank account").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
    }

    public void testSortByDate() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("creationDate", SortOrder.DESC).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Account)list.get(0)).getId());
        AssertJUnit.assertEquals((int)2, (int)((Account)list.get(1)).getId());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(2)).getId());
    }

    public void testSampleDomainQuery3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).having("gender").eq((Object)User.Gender.MALE).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(1)).getName());
    }

    public void testSampleDomainQuery4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(1)).getName());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(2)).getName());
    }

    public void testSampleDomainQuery4With2SortingOptions() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).orderBy("surname", SortOrder.ASC).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(1)).getName());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(2)).getName());
        AssertJUnit.assertEquals((String)"Man", (String)((User)list.get(0)).getSurname());
        AssertJUnit.assertEquals((String)"Woman", (String)((User)list.get(1)).getSurname());
        AssertJUnit.assertEquals((String)"Doe", (String)((User)list.get(2)).getSurname());
    }

    public void testSampleDomainQuery5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).select(new String[]{"name"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(2))[0]);
    }

    public void testSampleDomainQuery6() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John")).and().having("surname").eq((Object)"Doe").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Doe", (String)((User)list.get(0)).getSurname());
    }

    public void testSampleDomainQuery7() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)1)).and().having("description").like("%rent%").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Transaction)list.get(0)).getId());
        AssertJUnit.assertEquals((int)1, (int)((Transaction)list.get(0)).getAccountId());
        AssertJUnit.assertTrue((boolean)((Transaction)list.get(0)).getDescription().contains("rent"));
    }

    public void testSampleDomainQuery8() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        for (Transaction t : list) {
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((t.getDate().compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSampleDomainQuery9() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-01-01"), (Object)this.makeDate("2013-01-31")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)4, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(3)).length);
        for (int i = 0; i < 4; ++i) {
            Date d = (Date)((Object[])list.get(i))[0];
            AssertJUnit.assertTrue((d.compareTo(this.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            AssertJUnit.assertTrue((d.compareTo(this.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSampleDomainQuery10() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)2)).and().having("amount").gt((Object)40).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)52, (int)list.size());
        AssertJUnit.assertTrue((((Transaction)list.get(0)).getAmount() > 40.0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((((Transaction)list.get(1)).getAmount() > 40.0 ? 1 : 0) != 0);
    }

    public void testSampleDomainQuery11() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John")).and().having("addresses.postCode").eq((Object)"X1234")).and((FilterConditionContext)qf.having("accountIds").eq((Object)1)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"Doe", (String)((User)list.get(0)).getSurname());
    }

    public void testSampleDomainQuery12() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)1)).and().not().having("isDebit").eq((Object)true).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertFalse((boolean)((Transaction)list.get(0)).isDebit());
    }

    public void testSampleDomainQuery13() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)3).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((User)list.get(0)).getId());
        AssertJUnit.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(3));
    }

    public void testSampleDomainQuery14() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{2, 1}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((User)list.get(0)).getId());
        AssertJUnit.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(1));
        AssertJUnit.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(2));
    }

    public void testSampleDomainQuery15() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("accountIds").containsAny(new Object[]{1, 3}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery16() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getTransactionImplClass()).startOffset(20L)).maxResults(10)).orderBy("id", SortOrder.ASC).having("accountId").eq((Object)2)).and().having("description").like("Expensive%").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)50, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)10, (int)list.size());
        for (int i = 0; i < 10; ++i) {
            AssertJUnit.assertEquals((String)("Expensive shoes " + (20 + i)), (String)((Transaction)list.get(i)).getDescription());
        }
    }

    public void testSampleDomainQuery17() {
        QueryFactory qf = this.getQueryFactory();
        Query q1 = qf.from(this.getModelFactory().getUserImplClass()).having("id").eq((Object)1).build();
        List users = q1.list();
        Query q2 = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("description", SortOrder.ASC).having("id").in(((User)users.get(0)).getAccountIds()).build();
        List list = q2.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"John Doe's first bank account", (String)((Account)list.get(0)).getDescription());
        AssertJUnit.assertEquals((String)"John Doe's second bank account", (String)((Account)list.get(1)).getDescription());
    }

    public void testSampleDomainQuery18() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getTransactionImplClass()).orderBy("description", SortOrder.ASC).having("accountId").eq((Object)1)).and((FilterConditionContext)qf.having("amount").gt((Object)1600).or().having("description").like("%rent%")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((String)"Birthday present", (String)((Transaction)list.get(0)).getDescription());
        AssertJUnit.assertEquals((String)"Feb. rent payment", (String)((Transaction)list.get(1)).getDescription());
    }

    public void testProjectionOnOptionalField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"id", "age"}).orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((Object)1, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(2))[0]);
        AssertJUnit.assertEquals((Object)22, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testNullOnIntegerField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("age").isNull().or().having("age").equal((Object)-1).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertNull((Object)((User)list.get(0)).getAge());
        AssertJUnit.assertNull((Object)((User)list.get(1)).getAge());
    }

    public void testIsNotNullOnIntegerField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("age").isNull().and().not().having("age").equal((Object)-1).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((String)"Doe", (String)((User)list.get(0)).getSurname());
        AssertJUnit.assertNotNull((Object)((User)list.get(0)).getAge());
    }

    public void testSampleDomainQuery19() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("addresses.postCode").in(new Object[]{"ZZ", "X1234"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery20() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("addresses.postCode").in(new Object[]{"X1234"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery21() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("addresses").isNull().build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery22() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("addresses.postCode").like("%123%").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery23() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((User)list.get(0)).getId());
    }

    public void testSampleDomainQuery24() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).includeLower(false).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery25() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).includeUpper(false).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        AssertJUnit.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery26() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("creationDate").eq((Object)this.makeDate("2013-01-20")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Account)list.get(0)).getId());
    }

    public void testSampleDomainQuery27() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("id", SortOrder.ASC).having("creationDate").lt((Object)this.makeDate("2013-01-20")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
        AssertJUnit.assertEquals((int)2, (int)((Account)list.get(1)).getId());
    }

    public void testSampleDomainQuery28() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).orderBy("id", SortOrder.ASC).having("creationDate").lte((Object)this.makeDate("2013-01-20")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
        AssertJUnit.assertEquals((int)2, (int)((Account)list.get(1)).getId());
        AssertJUnit.assertEquals((int)3, (int)((Account)list.get(2)).getId());
    }

    public void testSampleDomainQuery29() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("creationDate").gt((Object)this.makeDate("2013-01-04")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Account)list.get(0)).getId());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding1() {
        QueryFactory qf = this.getQueryFactory();
        qf.not().having("name").eq((Object)"John").build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding2() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").having("surname").eq((Object)"Man").build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding3() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"John").not().having("surname").eq((Object)"Man").build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding4() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).not((FilterConditionContext)qf.having("name").eq((Object)"John")).not((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding5() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).not((FilterConditionContext)qf.having("name").eq((Object)"John")).not((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWrongQueryBuilding6() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq(null).build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding7() {
        QueryFactory qf = this.getQueryFactory();
        FilterConditionEndContext q1 = qf.from(this.getModelFactory().getUserImplClass()).having("gender");
        q1.eq((Object)User.Gender.MALE);
        q1.eq((Object)User.Gender.FEMALE);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014823: maxResults must be greater than 0")
    public void testPagination1() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).maxResults(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014823: maxResults must be greater than 0")
    public void testPagination2() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).maxResults(-4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014824: startOffset cannot be less than 0")
    public void testPagination3() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).startOffset(-3L);
    }

    public void testOrderedPagination4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).maxResults(5)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testUnorderedPagination4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).maxResults(5)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testOrderedPagination5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(20L)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testUnorderedPagination5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).startOffset(20L)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testOrderedPagination6() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(20L)).maxResults(10)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testUnorderedPagination6() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).startOffset(20L)).maxResults(10)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testOrderedPagination7() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(1L)).maxResults(10)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testUnorderedPagination7() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).startOffset(1L)).maxResults(10)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testOrderedPagination8() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(0L)).maxResults(2)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testUnorderedPagination8() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(this.getModelFactory().getUserImplClass()).startOffset(0L)).maxResults(2)).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)q.getResultSize());
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testGroupBy1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
    }

    public void testGroupBy2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertNull((Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014026: The expression 'surname' must be part of an aggregate function or it should be included in the GROUP BY clause")
    public void testGroupBy3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).groupBy(new String[]{"name"}).orderBy("surname").build();
        q.list();
    }

    public void testGroupBy4() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.postCode")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014021: Queries containing grouping and aggregation functions must use projections.")
    public void testGroupBy5() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).groupBy(new String[]{"name"}).build();
        q.list();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Aggregation SUM cannot be applied to property of type java.lang.String")
    public void testGroupBy6() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"name")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028515: Cannot have aggregate functions in the WHERE clause : SUM.")
    public void testGroupBy7() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).having(Expression.sum((String)"age")).gt((Object)10).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((double)1500.0, (double)((Double)((Object[])list.get(0))[2]), (double)1.0E-4);
        AssertJUnit.assertEquals((double)45.0, (double)((Double)((Object[])list.get(1))[2]), (double)1.0E-4);
    }

    public void testHavingWithSum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.sum((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.sum((String)"amount")).gt((Object)3324).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((double)6370.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testHavingWithAvg() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.avg((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.avg((String)"amount")).lt((Object)130.0).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((double)120.188679, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testHavingWithMin() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.min((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.min((String)"amount")).lt((Object)10).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((double)5.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testHavingWithMax() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.max((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.avg((String)"amount")).lt((Object)150).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((double)149.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    public void testSum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertNull((Object)((Object[])list.get(1))[0]);
    }

    public void testEmbeddedSum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.sum((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)156L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)300L, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testGlobalSum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.sum((String)"amount")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((double)9693.0, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
    }

    public void testEmbeddedGlobalSum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"addresses.number")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)456L, (Object)((Object[])list.get(0))[0]);
    }

    public void testCount() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.count((String)"age")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)0L, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertEquals((Object)0L, (Object)((Object[])list.get(2))[1]);
    }

    public void testEmbeddedCount1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.count((String)"accountIds")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)2L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertEquals((Object)0L, (Object)((Object[])list.get(2))[1]);
    }

    public void testEmbeddedCount2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.count((String)"addresses.street")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)2L, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertEquals((Object)0L, (Object)((Object[])list.get(2))[1]);
    }

    public void testGlobalCount() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).select(new Expression[]{Expression.count((String)"creationDate")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3L, (Object)((Object[])list.get(0))[0]);
    }

    public void testEmbeddedGlobalCount() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"accountIds")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3L, (Object)((Object[])list.get(0))[0]);
    }

    public void testAvg() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.avg((String)"amount")}).groupBy(new String[]{"accountId"}).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((double)1107.6666, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        AssertJUnit.assertEquals((double)120.18867, (double)((Double)((Object[])list.get(1))[1]), (double)1.0E-4);
    }

    public void testEmbeddedAvg() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.avg((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((double)156.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        AssertJUnit.assertEquals((double)150.0, (double)((Double)((Object[])list.get(1))[1]), (double)1.0E-4);
        AssertJUnit.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testGlobalAvg() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.avg((String)"amount")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((double)173.0892, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
    }

    public void testEmbeddedGlobalAvg() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"addresses.number")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((double)152.0, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
    }

    public void testMin() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.min((String)"amount")}).groupBy(new String[]{"accountId"}).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)23.0, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)5.0, (Object)((Object[])list.get(1))[1]);
    }

    public void testMinString() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"surname")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"Doe", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Man", (Object)((Object[])list.get(1))[0]);
    }

    public void testEmbeddedMin() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.min((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)156, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)-12, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testGlobalMinDouble() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.min((String)"amount")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)5.0, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalMinString() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"name")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
    }

    public void testEmbeddedGlobalMin() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"addresses.number")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)-12, (Object)((Object[])list.get(0))[0]);
    }

    public void testMax() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.max((String)"amount")}).groupBy(new String[]{"accountId"}).orderBy("accountId").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)1800.0, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)149.0, (Object)((Object[])list.get(1))[1]);
    }

    public void testMaxString() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"surname")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"Doe", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Woman", (Object)((Object[])list.get(1))[0]);
    }

    public void testEmbeddedMax() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.max((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(2)).length);
        AssertJUnit.assertEquals((Object)156, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)312, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testEmbeddedMaxString() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.postCode")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    public void testGlobalMaxDouble() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.max((String)"amount")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1800.0, (Object)((Object[])list.get(0))[0]);
    }

    public void testGlobalMaxString() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"name")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
    }

    public void testEmbeddedGlobalMax() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.number")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)312, (Object)((Object[])list.get(0))[0]);
    }

    public void testOrderBySum() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).orderBy(Expression.sum((String)"age")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
    }

    public void testGroupingWithFilter() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).having("name").eq((Object)"John").groupBy(new String[]{"name"}).having("name").eq((Object)"John").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
    }

    public void testCountNull() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"age")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
    }

    public void testCountNull2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"name"), Expression.count((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)0L, (Object)((Object[])list.get(1))[1]);
    }

    public void testCountNull3() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"name"), Expression.count((String)"salutation")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)0L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)2L, (Object)((Object[])list.get(1))[1]);
    }

    public void testAvgNull() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"age")}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)22.0, (Object)((Object[])list.get(0))[0]);
    }

    public void testDateGrouping1() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-02-15"), (Object)this.makeDate("2013-03-15")).groupBy(new String[]{"date"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
    }

    public void testDateGrouping2() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
    }

    public void testDateGrouping3() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.min((String)"date"), Expression.count((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
    }

    public void testParam() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)Expression.param((String)"param2")).build();
        q.setParameter("param2", (Object)User.Gender.MALE);
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        AssertJUnit.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(1)).getGender()));
        q.setParameter("param2", (Object)User.Gender.FEMALE);
        list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)((Object)User.Gender.FEMALE), (Object)((Object)((User)list.get(0)).getGender()));
    }

    public void testWithParameterMap() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("gender").eq((Object)Expression.param((String)"param1"))).and().having("name").eq((Object)Expression.param((String)"param2")).build();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("param1", (Object)User.Gender.MALE);
        parameterMap.put("param2", "John");
        q.setParameters(parameterMap);
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        AssertJUnit.assertEquals((String)"John", (String)((User)list.get(0)).getName());
        parameterMap = new HashMap(2);
        parameterMap.put("param1", (Object)User.Gender.MALE);
        parameterMap.put("param2", "Spider");
        q.setParameters(parameterMap);
        list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        AssertJUnit.assertEquals((String)"Spider", (String)((User)list.get(0)).getName());
    }

    public void testDateParam() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getAccountImplClass()).having("creationDate").eq((Object)Expression.param((String)"param1")).build().setParameter("param1", (Object)this.makeDate("2013-01-03"));
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Account)list.get(0)).getId());
    }

    public void testParamWithGroupBy() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.property((String)"date"), Expression.sum((String)"amount")}).groupBy(new String[]{"accountId", "date"}).having(Expression.sum((String)"amount")).gt((Object)Expression.param((String)"param")).build();
        q.setParameter("param", (Object)1801);
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)6225.0, (Object)((Object[])list.get(0))[2]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014805: No parameter named 'param2' was found")
    public void testUnknownParam() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1")).build();
        q.setParameter("param2", (Object)"John");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014806: No parameters named '\\[param2\\]' were found")
    public void testUnknownParamWithParameterMap() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1")).build();
        HashMap<String, User.Gender> parameterMap = new HashMap<String, User.Gender>(1);
        parameterMap.put("param2", User.Gender.MALE);
        q.setParameters(parameterMap);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014804: Query does not have parameters")
    public void testQueryWithNoParams() {
        QueryFactory qf = this.getQueryFactory();
        qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build().setParameter("param1", (Object)"John");
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014804: Query does not have parameters")
    public void testQueryWithNoParamsWithParameterMap() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build();
        HashMap<String, User.Gender> parameterMap = new HashMap<String, User.Gender>(1);
        parameterMap.put("param1", User.Gender.MALE);
        q.setParameters(parameterMap);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014803: Parameter name cannot be null or empty")
    public void testNullParamName() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param(null)).build();
        q.setParameter(null, (Object)"John");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014803: Parameter name cannot be null or empty")
    public void testEmptyParamName() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"")).build();
        q.setParameter("", (Object)"John");
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014825: Query parameter 'param2' was not set")
    public void testMissingParam() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1"))).and().having("gender").eq((Object)Expression.param((String)"param2")).build();
        q.setParameter("param1", (Object)"John");
        q.list();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="ISPN014825: Query parameter 'param2' was not set")
    public void testMissingParamWithParameterMap() {
        QueryFactory qf = this.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1"))).and().having("gender").eq((Object)Expression.param((String)"param2")).build();
        HashMap<String, String> parameterMap = new HashMap<String, String>(1);
        parameterMap.put("param1", "John");
        q.setParameters(parameterMap);
        q.list();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN014812: paramValues cannot be null")
    public void testQueryWithNoParamsWithNullParameterMap() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build();
        q.setParameters(null);
    }

    @Test
    public void testComplexQuery() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.avg((String)"amount"), Expression.sum((String)"amount"), Expression.count((String)"date"), Expression.min((String)"date"), Expression.max((String)"accountId")}).having("isDebit").eq((Object)Expression.param((String)"param")).orderBy(Expression.avg((String)"amount"), SortOrder.DESC).orderBy(Expression.count((String)"date"), SortOrder.DESC).orderBy(Expression.max((String)"amount"), SortOrder.ASC).build();
        q.setParameter("param", (Object)true);
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)5, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((double)143.50909, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
        AssertJUnit.assertEquals((double)7893.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        AssertJUnit.assertEquals((Object)55L, (Object)((Object[])list.get(0))[2]);
        AssertJUnit.assertEquals(Date.class, ((Object[])list.get(0))[3].getClass());
        AssertJUnit.assertEquals((Object)this.makeDate("2013-01-01"), (Object)((Object[])list.get(0))[3]);
        AssertJUnit.assertEquals((Object)2, (Object)((Object[])list.get(0))[4]);
    }

    public void testDateFilteringWithGroupBy() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)this.makeDate("2013-02-15"), (Object)this.makeDate("2013-03-15")).groupBy(new String[]{"date"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals(Date.class, ((Object[])list.get(0))[0].getClass());
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
    }

    public void testAggregateDate() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals(Date.class, ((Object[])list.get(0))[1].getClass());
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
    }

    public void testNotIndexedProjection() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isValid"}).having("id").gte((Object)98).orderBy("id").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(1))[1]);
    }

    public void testNotStoredProjection() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "description"}).having("id").gte((Object)98).orderBy("id").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Expensive shoes 48", (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)"Expensive shoes 49", (Object)((Object[])list.get(1))[1]);
    }

    public void testNotIndexedOrderBy() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isValid"}).having("id").gte((Object)98).orderBy("isValid").orderBy("id").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(1))[1]);
    }

    public void testNotStoredOrderBy() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "description"}).having("id").gte((Object)98).orderBy("description").orderBy("id").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Expensive shoes 48", (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(1)).length);
        AssertJUnit.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)"Expensive shoes 49", (Object)((Object[])list.get(1))[1]);
    }

    public void testDuplicateDateProjection() throws Exception {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "date", "date"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)this.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[2]);
    }

    public void testDuplicateBooleanProjection() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isDebit", "isDebit"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)3, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)true, (Object)((Object[])list.get(0))[2]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014023: Using the multi-valued property path 'addresses.street' in the GROUP BY clause is not currently supported")
    public void testGroupByMustNotAcceptRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"name")}).groupBy(new String[]{"addresses.street"}).build();
        q.list();
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN014024: The property path 'addresses.street' cannot be used in the ORDER BY clause because it is multi-valued")
    public void testOrderByMustNotAcceptRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).orderBy("addresses.street").build();
        q.list();
    }

    public void testOrderByInAggregationQueryMustAcceptRepeatedProperty() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"age"), Expression.property((String)"name")}).having("name").gt((Object)"A").groupBy(new String[]{"name"}).having(Expression.max((String)"addresses.street")).gt((Object)"A").orderBy(Expression.min((String)"addresses.street")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertNull((Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)22.0, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)"John", (Object)((Object[])list.get(1))[1]);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="ISPN028515: Cannot have aggregate functions in the WHERE clause : MIN.")
    public void testRejectAggregationsInWhereClause() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new String[]{"name"}).having("name").eq((Object)Expression.min((String)"addresses.street")).build();
        q.list();
    }

    public void testAggregateRepeatedField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"addresses.street")}).having("name").eq((Object)"Spider").build();
        List list = q.list();
        AssertJUnit.assertEquals((Object)"Bond Street", (Object)((Object[])list.get(0))[0]);
    }

    public void testGroupingAndAggregationOnSameField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"surname")}).groupBy(new String[]{"surname"}).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)1, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(2))[0]);
    }

    public void testTwoPhaseGroupingAndAggregationOnSameField() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"surname"), Expression.sum((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((Object[])list.get(0)).length);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)156L, (Object)((Object[])list.get(0))[1]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(1))[0]);
        AssertJUnit.assertEquals((Object)300L, (Object)((Object[])list.get(1))[1]);
        AssertJUnit.assertEquals((Object)1L, (Object)((Object[])list.get(2))[0]);
        AssertJUnit.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testLuceneWildcardsAreEscaped() {
        QueryFactory qf = this.getQueryFactory();
        Query q1 = qf.from(this.getModelFactory().getUserImplClass()).having("name").like("J%n").build();
        AssertJUnit.assertEquals((int)1, (int)q1.list().size());
        Query q2 = qf.from(this.getModelFactory().getUserImplClass()).having("name").like("J*n").build();
        AssertJUnit.assertEquals((int)0, (int)q2.list().size());
        Query q3 = qf.from(this.getModelFactory().getUserImplClass()).having("name").like("Jo_n").build();
        AssertJUnit.assertEquals((int)1, (int)q3.list().size());
        Query q4 = qf.from(this.getModelFactory().getUserImplClass()).having("name").like("Jo?n").build();
        AssertJUnit.assertEquals((int)0, (int)q4.list().size());
    }

    public void testCompareLongWithInt() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).having(Expression.sum((String)"age")).gt((Object)50000).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testCompareDoubleWithInt() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.sum((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.sum((String)"amount")).gt((Object)50000).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testFullTextTerm() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.create("from " + this.getModelFactory().getTransactionTypeName() + " where longDescription:'rent'");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    public void testFullTextPhrase() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.create("from " + this.getModelFactory().getTransactionTypeName() + " where longDescription:'expensive shoes'");
        List list = q.list();
        AssertJUnit.assertEquals((int)50, (int)list.size());
    }

    public void testInstant1() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("creationDate").eq((Object)Instant.parse("2011-12-03T10:15:30Z")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testInstant2() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("passwordExpirationDate").eq((Object)Instant.parse("2011-12-03T10:15:30Z")).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testManyClauses() {
        QueryFactory qf = this.getQueryFactory();
        QueryBuilder qb = qf.from(this.getModelFactory().getUserImplClass());
        FilterConditionContext fcc = (FilterConditionContext)qb.having("name").eq((Object)"test");
        for (int i = 0; i < 1024; ++i) {
            fcc = (FilterConditionContext)fcc.and().having("name").eq((Object)("test" + i));
        }
        List list = qb.build().list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    public void testSingleIN() {
        QueryFactory qf = this.getQueryFactory();
        Query q = qf.from(this.getModelFactory().getUserImplClass()).having("surname").in(new Object[]{"Man"}).and().having("gender").eq((Object)User.Gender.MALE).build();
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((int)2, (int)((User)list.get(0)).getId());
        AssertJUnit.assertEquals((String)"Man", (String)((User)list.get(0)).getSurname());
        AssertJUnit.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
    }
}

