/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.SegmentInfos;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.QueryInterceptorTest")
public class QueryInterceptorTest
extends AbstractInfinispanTest {
    private static final int MAX_CACHE_ENTRIES = 1;
    private File indexDir;
    private File storeDir;
    private final Person person1 = new Person("p1", "b1", 12);
    private final Person person2 = new Person("p2", "b2", 22);
    private final Car car1 = new Car("subaru", "blue", 200);
    private final Car car2 = new Car("lamborghini", "yellow", 230);

    @BeforeMethod
    protected void setup() throws Exception {
        this.indexDir = Files.createTempDirectory("test-", new FileAttribute[0]).toFile();
        this.storeDir = Files.createTempDirectory("test-", new FileAttribute[0]).toFile();
    }

    @AfterMethod
    protected void tearDown() {
        Util.recursiveFileRemove((File)this.indexDir);
        Util.recursiveFileRemove((File)this.storeDir);
    }

    @Test
    public void shouldNotReindexOnActivation() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(1)){

            public void call() {
                LuceneIndexTracker luceneIndexTracker = new LuceneIndexTracker(new File(QueryInterceptorTest.this.indexDir + "/person"));
                luceneIndexTracker.mark();
                Cache cache = this.cm.getCache();
                CacheListener cacheListener = new CacheListener();
                cache.addListener(cacheListener);
                cache.put((Object)"key1", (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)"key2", (Object)QueryInterceptorTest.this.person2);
                QueryInterceptorTest.this.forceCommit(cache);
                QueryInterceptorTest.this.eventuallyEquals(1, cacheListener::numberOfPassivations);
                Assert.assertEquals((int)cacheListener.numberOfActivations(), (int)0);
                Assert.assertTrue((boolean)luceneIndexTracker.indexChanged());
                luceneIndexTracker.mark();
                cache.get((Object)"key1");
                Assert.assertEquals((int)cacheListener.numberOfActivations(), (int)1);
                Assert.assertFalse((boolean)luceneIndexTracker.indexChanged());
            }
        });
    }

    @Test
    public void shouldNotReindexOnPreload() throws Exception {
        final LuceneIndexTracker luceneIndexTracker = new LuceneIndexTracker(new File(this.indexDir + "/person"));
        luceneIndexTracker.mark();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(1)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)"key1", (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)"key2", (Object)QueryInterceptorTest.this.person2);
                QueryInterceptorTest.this.forceCommit(cache);
                Assert.assertTrue((boolean)luceneIndexTracker.indexChanged());
            }
        });
        luceneIndexTracker.mark();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(11)){

            public void call() {
                Cache cache = this.cm.getCache();
                CacheListener cacheListener = new CacheListener();
                cache.addListener(cacheListener);
                Assert.assertTrue((boolean)cache.containsKey((Object)"key1"));
                Assert.assertTrue((boolean)cache.containsKey((Object)"key2"));
                Assert.assertEquals((int)cacheListener.numberOfPassivations(), (int)0);
                Assert.assertEquals((int)cacheListener.numberOfActivations(), (int)0);
                Assert.assertFalse((boolean)luceneIndexTracker.indexChanged());
            }
        });
    }

    @Test
    public void shouldDeleteSingleIndex() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(1)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)"P1", (Object)QueryInterceptorTest.this.person1);
                cache.put((Object)"P2", (Object)QueryInterceptorTest.this.person2);
                cache.put((Object)"C1", (Object)QueryInterceptorTest.this.car1);
                cache.put((Object)"C2", (Object)QueryInterceptorTest.this.car2);
                QueryInterceptorTest.this.forceCommit(cache);
                Assert.assertEquals((long)2L, (long)QueryInterceptorTest.this.countIndex(Car.class, cache));
                Assert.assertEquals((long)2L, (long)QueryInterceptorTest.this.countIndex(Person.class, cache));
                Indexer indexer = Search.getIndexer((Cache)cache);
                CompletionStages.join((CompletionStage)indexer.remove(new Class[]{Car.class}));
                Assert.assertEquals((long)0L, (long)QueryInterceptorTest.this.countIndex(Car.class, cache));
                Assert.assertEquals((long)2L, (long)QueryInterceptorTest.this.countIndex(Person.class, cache));
                CompletionStages.join((CompletionStage)indexer.remove(new Class[]{Person.class}));
                Assert.assertEquals((long)0L, (long)QueryInterceptorTest.this.countIndex(Car.class, cache));
                Assert.assertEquals((long)0L, (long)QueryInterceptorTest.this.countIndex(Person.class, cache));
            }
        });
    }

    protected EmbeddedCacheManager createCacheManager(int maxEntries) throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.globalState().enable().persistentLocation(this.storeDir.getAbsolutePath());
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)QueryTestSCI.INSTANCE);
        ConfigurationBuilder b = new ConfigurationBuilder();
        ((SingleFileStoreConfigurationBuilder)b.memory().evictionType(EvictionType.COUNT).size((long)maxEntries).persistence().passivation(true).addSingleFileStore().preload(true)).indexing().enable().addIndexedEntity(Person.class).addIndexedEntity(Car.class).addProperty("directory.type", "local-filesystem").addProperty("directory.root", this.indexDir.getAbsolutePath());
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)b);
    }

    private long countIndex(Class<?> entityType, Cache<?, ?> cache) {
        Query query = Search.getQueryFactory(cache).create("FROM " + entityType.getName());
        return query.execute().hitCount().orElse(-1L);
    }

    private void forceCommit(Cache<?, ?> cache) {
        TestQueryHelperFactory.extractSearchMapping(cache).scopeAll().workspace().flush();
    }

    @Listener
    private static final class CacheListener<K, V> {
        private final LongAdder passivationCount = new LongAdder();
        private final LongAdder activationCount = new LongAdder();

        private CacheListener() {
        }

        @CacheEntryPassivated
        public void onEvent(CacheEntryPassivatedEvent<K, V> payload) {
            if (!payload.isPre()) {
                this.passivationCount.increment();
            }
        }

        @CacheEntryActivated
        public void onEvent(CacheEntryActivatedEvent<K, V> payload) {
            if (!payload.isPre()) {
                this.activationCount.increment();
            }
        }

        public int numberOfPassivations() {
            return this.passivationCount.intValue();
        }

        public int numberOfActivations() {
            return this.activationCount.intValue();
        }
    }

    private static final class LuceneIndexTracker {
        private final File indexBase;
        private long indexVersion;

        public LuceneIndexTracker(File indexBase) {
            this.indexBase = indexBase;
        }

        public void mark() {
            this.indexVersion = this.getLuceneIndexVersion();
        }

        public boolean indexChanged() {
            return this.getLuceneIndexVersion() != this.indexVersion;
        }

        private long getLuceneIndexVersion() {
            return this.indexBase.list() == null ? -1L : SegmentInfos.getLastCommitGeneration((String[])this.indexBase.list());
        }
    }
}

