/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.ProgrammaticAutoConfigTest")
public class ProgrammaticAutoConfigTest {
    @Test
    public void testWithoutAutoConfig() {
        IndexingConfiguration cfg = new ConfigurationBuilder().indexing().enable().create();
        Assert.assertTrue((boolean)cfg.properties().isEmpty());
    }

    @Test
    public void testLocalWitAutoConfig() {
        IndexingConfiguration cfg = new ConfigurationBuilder().indexing().enable().autoConfig(true).create();
        Assert.assertFalse((boolean)cfg.properties().isEmpty());
        Assert.assertEquals((Object)cfg.properties().get((Object)"hibernate.search.backend.directory.type"), (Object)"local-filesystem");
    }

    @Test
    public void testDistWitAutoConfig() {
        IndexingConfiguration cfg = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).indexing().enable().autoConfig(true).create();
        Assert.assertFalse((boolean)cfg.properties().isEmpty());
        Assert.assertEquals((Object)cfg.properties().get((Object)"hibernate.search.backend.directory.type"), (Object)"local-filesystem");
    }

    @Test
    public void testOverride() {
        String override = "hibernate.search.default.exclusive_index_use";
        IndexingConfiguration cfg = new ConfigurationBuilder().indexing().enable().autoConfig(true).addProperty(override, "false").create();
        Assert.assertEquals((Object)cfg.properties().get((Object)override), (Object)"false");
    }
}

