/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.SegmentListener;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.logging.Log;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.work.SearchIndexer;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;

public final class QueryInterceptor
extends DDAsyncInterceptor {
    private static final Log log = (Log)LogFactory.getLog(QueryInterceptor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    static final Object UNKNOWN = new Object(){

        public String toString() {
            return "<UNKNOWN>";
        }
    };
    @Inject
    DistributionManager distributionManager;
    @Inject
    BlockingManager blockingManager;
    @Inject
    protected KeyPartitioner keyPartitioner;
    private final KeyTransformationHandler keyTransformationHandler;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final ConcurrentMap<GlobalTransaction, Map<Object, Object>> txOldValues;
    private final DataConversion valueDataConversion;
    private final DataConversion keyDataConversion;
    private final boolean isPersistenceEnabled;
    private final InvocationSuccessAction<ClearCommand> processClearCommand = this::processClearCommand;
    private final boolean isManualIndexing;
    private final AdvancedCache<?, ?> cache;
    private final Map<String, Class<?>> indexedClasses;
    private SearchMapping searchMapping;
    private SegmentListener segmentListener;

    public QueryInterceptor(KeyTransformationHandler keyTransformationHandler, boolean isManualIndexing, ConcurrentMap<GlobalTransaction, Map<Object, Object>> txOldValues, AdvancedCache<?, ?> cache, Map<String, Class<?>> indexedClasses) {
        this.keyTransformationHandler = keyTransformationHandler;
        this.isManualIndexing = isManualIndexing;
        this.txOldValues = txOldValues;
        this.valueDataConversion = cache.getValueDataConversion();
        this.keyDataConversion = cache.getKeyDataConversion();
        this.isPersistenceEnabled = cache.getCacheConfiguration().persistence().usingStores();
        this.cache = cache;
        this.indexedClasses = Collections.unmodifiableMap(indexedClasses);
    }

    @Start
    protected void start() {
        this.stopping.set(false);
        boolean isClustered = this.cache.getCacheConfiguration().clustering().cacheMode().isClustered();
        if (isClustered) {
            this.segmentListener = new SegmentListener(this.cache, this::purgeIndex, this.blockingManager);
            this.cache.addListener((Object)this.segmentListener);
        }
        this.searchMapping = ComponentRegistryUtils.getSearchMapping(this.cache);
    }

    public void prepareForStopping() {
        if (this.segmentListener != null) {
            this.cache.removeListener((Object)this.segmentListener);
        }
        this.stopping.set(true);
    }

    private boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx, Object key) {
        if (this.isManualIndexing) {
            return false;
        }
        if (this.distributionManager == null || key == null) {
            return true;
        }
        DistributionInfo info = this.distributionManager.getCacheTopology().getDistribution(key);
        return info.isPrimary() || info.isWriteOwner() && (ctx.isInTxScope() || !ctx.isOriginLocal() || command != null && command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER));
    }

    public BlockingManager getBlockingManager() {
        return this.blockingManager;
    }

    private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        Object prev;
        if (command.hasAnyFlag(FlagBitSets.SKIP_INDEXING)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (ctx.isInTxScope()) {
            if (!(entry == null || entry.isChanged() || entry.getValue() == null && this.unreliablePreviousValue((WriteCommand)command))) {
                Map<Object, Object> oldValues = this.registerOldValues((TxInvocationContext)ctx);
                oldValues.putIfAbsent(command.getKey(), entry.getValue());
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        Object object = prev = entry != null ? entry.getValue() : UNKNOWN;
        if (prev == null && this.unreliablePreviousValue((WriteCommand)command)) {
            prev = UNKNOWN;
        }
        Object oldValue = prev;
        return this.invokeNextThenApply(ctx, (VisitableCommand)command, (rCtx, cmd, rv) -> {
            CacheEntry entry2;
            if (!cmd.isSuccessful()) {
                return rv;
            }
            CacheEntry cacheEntry = entry2 = entry != null ? entry : rCtx.lookupEntry(cmd.getKey());
            if (entry2 != null && entry2.isChanged()) {
                return QueryInterceptor.asyncValue((CompletionStage)this.processChange(rCtx, (FlagAffectedCommand)cmd, cmd.getKey(), oldValue, entry2.getValue()).thenApply(ignore -> rv));
            }
            return rv;
        });
    }

    private Map<Object, Object> registerOldValues(TxInvocationContext ctx) {
        return this.txOldValues.computeIfAbsent(ctx.getGlobalTransaction(), gid -> {
            ctx.getCacheTransaction().addListener(() -> this.txOldValues.remove(gid));
            return new HashMap();
        });
    }

    private Object handleManyWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_INDEXING)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        if (ctx.isInTxScope()) {
            Map<Object, Object> oldValues = this.registerOldValues((TxInvocationContext)ctx);
            for (Object key : command.getAffectedKeys()) {
                CacheEntry entry = ctx.lookupEntry(key);
                if (entry == null || entry.isChanged() || entry.getValue() == null && this.unreliablePreviousValue(command)) continue;
                oldValues.putIfAbsent(key, entry.getValue());
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        HashMap oldValues = new HashMap();
        for (Object key : command.getAffectedKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null || entry.getValue() == null && this.unreliablePreviousValue(command)) continue;
            oldValues.put(key, entry.getValue());
        }
        return this.invokeNextThenApply(ctx, (VisitableCommand)command, (rCtx, cmd, rv) -> {
            if (!cmd.isSuccessful()) {
                return rv;
            }
            return QueryInterceptor.asyncValue(CompletableFuture.allOf((CompletableFuture[])cmd.getAffectedKeys().stream().map(key -> {
                CacheEntry entry = rCtx.lookupEntry(key);
                if (entry != null && entry.isChanged()) {
                    Object oldValue = oldValues.getOrDefault(key, UNKNOWN);
                    return this.processChange(rCtx, (FlagAffectedCommand)cmd, key, oldValue, entry.getValue());
                }
                return CompletableFutures.completedNull();
            }).toArray(CompletableFuture[]::new)));
        });
    }

    private boolean unreliablePreviousValue(WriteCommand command) {
        return this.isPersistenceEnabled && (command.loadType() == VisitableCommand.LoadType.DONT_LOAD || command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD));
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNextThenAccept(ctx, (VisitableCommand)command, this.processClearCommand);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.handleManyWriteCommand(ctx, (WriteCommand)command);
    }

    public void purgeAllIndexes() {
        if (this.searchMapping == null) {
            return;
        }
        this.searchMapping.scopeAll().workspace().purge();
    }

    public void purgeIndex(Class<?> entityType) {
        if (this.searchMapping == null) {
            return;
        }
        this.searchMapping.scope(entityType).workspace().purge();
    }

    void purgeIndex(IntSet segments) {
        if (segments == null || segments.isEmpty() || this.searchMapping == null) {
            return;
        }
        Set<String> routingKeys = segments.intStream().boxed().map(Objects::toString).collect(Collectors.toSet());
        this.searchMapping.scopeAll().workspace().purge(routingKeys);
    }

    CompletableFuture<?> removeFromIndexes(Object key, int segment) {
        return this.getSearchIndexer().purge(this.keyToString(key), String.valueOf(segment));
    }

    private CompletableFuture<?> removeFromIndexes(Object value, Object key, int segment) {
        return this.getSearchIndexer().delete(this.keyToString(key), String.valueOf(segment), value);
    }

    private CompletableFuture<?> updateIndexes(boolean usingSkipIndexCleanupFlag, Object value, Object key, int segment) {
        if (usingSkipIndexCleanupFlag) {
            return this.getSearchIndexer().add(this.keyToString(key), String.valueOf(segment), value);
        }
        return this.getSearchIndexer().addOrUpdate(this.keyToString(key), String.valueOf(segment), value);
    }

    @Deprecated
    public Map<String, Class<?>> indexedEntities() {
        return this.indexedClasses;
    }

    private SearchIndexer getSearchIndexer() {
        return this.searchMapping.getSearchIndexer();
    }

    private Object extractValue(Object storedValue) {
        return this.valueDataConversion.extractIndexable(storedValue);
    }

    private Object extractKey(Object storedKey) {
        return this.keyDataConversion.extractIndexable(storedKey);
    }

    private String keyToString(Object key) {
        return this.keyTransformationHandler.keyToString(key);
    }

    public KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    CompletableFuture<?> processChange(InvocationContext ctx, FlagAffectedCommand command, Object storedKey, Object storedOldValue, Object storedNewValue) {
        int segment = SegmentSpecificCommand.extractSegment((ReplicableCommand)command, (Object)storedKey, (KeyPartitioner)this.keyPartitioner);
        Object key = this.extractKey(storedKey);
        Object oldValue = storedOldValue == UNKNOWN ? UNKNOWN : this.extractValue(storedOldValue);
        Object newValue = this.extractValue(storedNewValue);
        boolean skipIndexCleanup = command != null && command.hasAnyFlag(FlagBitSets.SKIP_INDEX_CLEANUP);
        CompletionStage<Object> operation = CompletableFutures.completedNull();
        if (!skipIndexCleanup) {
            if (oldValue == UNKNOWN) {
                if (this.shouldModifyIndexes(command, ctx, storedKey)) {
                    operation = this.removeFromIndexes(key, segment);
                }
            } else if (this.isIndexedType(oldValue) && (newValue == null || this.shouldRemove(newValue, oldValue)) && this.shouldModifyIndexes(command, ctx, storedKey)) {
                operation = this.removeFromIndexes(oldValue, key, segment);
            } else if (trace) {
                log.tracef("Index cleanup not needed for %s -> %s", oldValue, newValue);
            }
        } else if (trace) {
            log.tracef("Skipped index cleanup for command %s", command);
        }
        if (this.isIndexedType(newValue)) {
            if (this.shouldModifyIndexes(command, ctx, storedKey)) {
                operation = operation.thenCompose(r -> this.updateIndexes(skipIndexCleanup, newValue, key, segment));
            } else if (trace) {
                log.tracef("Not modifying index for %s (%s)", storedKey, command);
            }
        } else if (trace) {
            log.tracef("Update not needed for %s", newValue);
        }
        return operation;
    }

    private boolean shouldRemove(Object value, Object previousValue) {
        return value != null && previousValue != null && value.getClass() != previousValue.getClass();
    }

    private void processClearCommand(InvocationContext ctx, ClearCommand command, Object rv) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)command, ctx, null)) {
            this.purgeAllIndexes();
        }
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    private boolean isIndexedType(Object value) {
        return this.searchMapping != null && this.searchMapping.isIndexedType(value);
    }
}

