/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public final class QueryResponse {
    private final NodeTopDocs nodeTopDocs;
    private final Integer resultSize;
    private final Object fetchedValue;

    public QueryResponse() {
        this.nodeTopDocs = null;
        this.resultSize = null;
        this.fetchedValue = null;
    }

    public QueryResponse(Object fetchedValue) {
        this.fetchedValue = fetchedValue;
        this.nodeTopDocs = null;
        this.resultSize = null;
    }

    public QueryResponse(int resultSize) {
        this.resultSize = resultSize;
        this.nodeTopDocs = null;
        this.fetchedValue = null;
    }

    public QueryResponse(NodeTopDocs nodeTopDocs) {
        this.resultSize = nodeTopDocs == null ? Integer.valueOf(0) : Integer.valueOf(Math.toIntExact(nodeTopDocs.topDocs == null ? 0L : nodeTopDocs.topDocs.totalHits.value));
        this.nodeTopDocs = nodeTopDocs;
        this.fetchedValue = null;
    }

    public NodeTopDocs getNodeTopDocs() {
        return this.nodeTopDocs;
    }

    public Integer getResultSize() {
        return this.resultSize;
    }

    public Object getFetchedValue() {
        return this.fetchedValue;
    }

    public static final class Externalizer
    implements AdvancedExternalizer<QueryResponse> {
        public Set<Class<? extends QueryResponse>> getTypeClasses() {
            return Collections.singleton(QueryResponse.class);
        }

        public Integer getId() {
            return ExternalizerIds.CLUSTERED_QUERY_COMMAND_RESPONSE;
        }

        public void writeObject(ObjectOutput output, QueryResponse queryResponse) throws IOException {
            output.writeObject(queryResponse.nodeTopDocs);
            if (queryResponse.nodeTopDocs == null) {
                output.writeObject(queryResponse.resultSize);
                if (queryResponse.resultSize == null) {
                    output.writeObject(queryResponse.fetchedValue);
                }
            }
        }

        public QueryResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            NodeTopDocs nodeTopDocs = (NodeTopDocs)input.readObject();
            if (nodeTopDocs != null) {
                return new QueryResponse(nodeTopDocs);
            }
            Integer resultSize = (Integer)input.readObject();
            if (resultSize != null) {
                return new QueryResponse(resultSize);
            }
            return new QueryResponse(input.readObject());
        }
    }
}

