/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.Version;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.QueryStatistics;
import org.infinispan.query.core.stats.SearchStatistics;

@MBean(objectName="Statistics", description="Statistics for index based query")
public final class InfinispanQueryStatisticsInfo {
    private final QueryStatistics queryStatistics;
    private final IndexStatistics indexStatistics;

    InfinispanQueryStatisticsInfo(SearchStatistics searchStatistics) {
        this.queryStatistics = searchStatistics.getQueryStatistics();
        this.indexStatistics = searchStatistics.getIndexStatistics();
    }

    @ManagedOperation
    public void clear() {
        this.queryStatistics.clear();
    }

    @ManagedAttribute
    public long getSearchQueryExecutionCount() {
        return this.queryStatistics.getLocalIndexedQueryCount();
    }

    @ManagedAttribute
    public long getSearchQueryTotalTime() {
        return this.queryStatistics.getLocalIndexedQueryTotalTime();
    }

    @ManagedAttribute
    public long getSearchQueryExecutionMaxTime() {
        return this.queryStatistics.getLocalIndexedQueryMaxTime();
    }

    @ManagedAttribute
    public long getSearchQueryExecutionAvgTime() {
        return Double.valueOf(this.queryStatistics.getLocalIndexedQueryAvgTime()).longValue();
    }

    @ManagedAttribute
    public String getSearchQueryExecutionMaxTimeQueryString() {
        String query = this.queryStatistics.getSlowestLocalIndexedQuery();
        return query == null ? "" : query;
    }

    @ManagedAttribute
    public long getObjectLoadingTotalTime() {
        return this.queryStatistics.getLoadCount();
    }

    @ManagedAttribute
    public long getObjectLoadingExecutionMaxTime() {
        return this.queryStatistics.getLoadTotalTime();
    }

    @ManagedAttribute
    public long getObjectLoadingExecutionAvgTime() {
        return Double.valueOf(this.queryStatistics.getLoadAvgTime()).longValue();
    }

    @ManagedAttribute
    public long getObjectsLoadedCount() {
        return this.queryStatistics.getLoadCount();
    }

    @ManagedAttribute
    public boolean isStatisticsEnabled() {
        return this.queryStatistics.isEnabled();
    }

    @ManagedAttribute
    public String getSearchVersion() {
        return Version.versionString();
    }

    @ManagedAttribute
    public Set<String> getIndexedClassNames() {
        return this.indexStatistics.indexInfos().keySet();
    }

    @ManagedOperation
    public int getNumberOfIndexedEntities(String entity) {
        return this.find(this.indexStatistics.indexInfos(), entity).map(IndexInfo::count).orElse(0L).intValue();
    }

    private Optional<IndexInfo> find(Map<String, IndexInfo> indexInfos, String entity) {
        return indexInfos.entrySet().stream().filter(e -> ((String)e.getKey()).equals(entity)).map(Map.Entry::getValue).findFirst();
    }

    @ManagedOperation
    public Map<String, Integer> indexedEntitiesCount() {
        return this.indexStatistics.indexInfos().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)((IndexInfo)e.getValue()).count()));
    }

    @ManagedOperation
    public long getIndexSize(String indexName) {
        return this.find(this.indexStatistics.indexInfos(), indexName).map(IndexInfo::size).orElse(0L);
    }

    @ManagedOperation
    public Map<String, Long> indexSizes() {
        return this.indexStatistics.indexInfos().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexInfo)e.getValue()).size()));
    }

    public Json getLegacyQueryStatistics() {
        return Json.object().set("search_query_execution_count", (Object)this.getSearchQueryExecutionCount()).set("search_query_total_time", (Object)this.getSearchQueryTotalTime()).set("search_query_execution_max_time", (Object)this.getSearchQueryExecutionMaxTime()).set("search_query_execution_avg_time", (Object)this.getSearchQueryExecutionAvgTime()).set("object_loading_total_time", (Object)this.getObjectLoadingTotalTime()).set("object_loading_execution_max_time", (Object)this.getObjectLoadingExecutionMaxTime()).set("object_loading_execution_avg_time", (Object)this.getObjectLoadingExecutionAvgTime()).set("objects_loaded_count", (Object)this.getObjectsLoadedCount()).set("search_query_execution_max_time_query_string", (Object)this.getSearchQueryExecutionMaxTimeQueryString());
    }

    public Json getLegacyIndexStatistics() {
        Map indexStats = this.indexStatistics.indexInfos();
        Map<String, Long> sizes = indexStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexInfo)e.getValue()).size()));
        return Json.object().set("indexed_class_names", Json.make(this.getIndexedClassNames())).set("indexed_entities_count", Json.make(indexStats.keySet())).set("index_sizes", Json.make(sizes)).set("reindexing", (Object)this.indexStatistics.reindexing());
    }
}

