/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.lucene.search.BooleanQuery;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metrics.impl.CacheMetricsRegistration;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.TxQueryInterceptor;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.embedded.impl.ObjectReflectionMatcher;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.CacheIdentifierBridge;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.PersistenceContextInitializerImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.SecurityActions;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneBytesRefExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFieldDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneScoreDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopFieldDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTotalHitsExternalizer;
import org.infinispan.query.impl.externalizers.PojoRawTypeIdentifierExternalizer;
import org.infinispan.query.impl.massindex.DistributedExecutorMassIndexer;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.logging.Log;
import org.infinispan.query.stats.impl.LocalIndexStatistics;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.search.mapper.mapping.ProgrammaticSearchMappingProvider;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.mapping.SearchMappingBuilder;
import org.infinispan.search.mapper.mapping.SearchMappingCommonBuilding;
import org.infinispan.search.mapper.mapping.impl.CompositeAnalysisConfigurer;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.LogFactory;

@InfinispanModule(name="query", requiredModules={"core", "query-core", "clustered-lock"}, optionalModules={"lucene-directory"})
public class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private static final String ANALYSIS_CONFIGURER_PROPERTY_NAME = "analysis.configurer";
    private static final String HS5_CONF_STRATEGY_PROPERTY = "hibernate.search.indexing_strategy";
    private static final String HS5_CONF_STRATEGY_MANUAL = "manual";
    public static final String MAX_BOOLEAN_CLAUSES_SYS_PROP = "infinispan.query.lucene.max-boolean-clauses";
    private static boolean maxBooleanClausesWasSet = false;

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        LocalQueryStatistics queryStatistics = (LocalQueryStatistics)cr.getComponent(LocalQueryStatistics.class);
        if (!icr.isInternalCache(cacheName) || icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.QUERYABLE)) {
            AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
            SecurityActions.addCacheDependency(cache.getCacheManager(), cacheName, "___query_cache");
            ClassLoader aggregatedClassLoader = this.makeAggregatedClassLoader(cr.getGlobalComponentRegistry().getGlobalConfiguration().classLoader());
            boolean isIndexed = cfg.indexing().enabled();
            SearchMapping searchMapping = null;
            if (isIndexed) {
                this.setBooleanQueryMaxClauseCount(cfg.indexing().properties());
                Map<String, Class<?>> indexedClasses = this.makeIndexedClassesMap(cache);
                KeyTransformationHandler keyTransformationHandler = new KeyTransformationHandler(aggregatedClassLoader);
                cr.registerComponent((Object)keyTransformationHandler, KeyTransformationHandler.class);
                searchMapping = this.createSearchMapping(queryStatistics, cfg.indexing(), indexedClasses, cr, cache, keyTransformationHandler, aggregatedClassLoader);
                this.createQueryInterceptorIfNeeded(cr, cfg, cache, indexedClasses, keyTransformationHandler);
                DistributedExecutorMassIndexer massIndexer = new DistributedExecutorMassIndexer(cache, keyTransformationHandler);
                cr.registerComponent((Object)massIndexer, Indexer.class);
                if (searchMapping != null) {
                    BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
                    bcr.replaceComponent(IndexStatistics.class.getName(), (Object)new LocalIndexStatistics(), true);
                    bcr.rewire();
                }
            }
            cr.registerComponent((Object)ObjectReflectionMatcher.create(new ReflectionEntityNamesResolver(aggregatedClassLoader), searchMapping), ObjectReflectionMatcher.class);
            cr.registerComponent(new QueryEngine(cache, isIndexed), QueryEngine.class);
        }
    }

    private Map<String, Class<?>> makeIndexedClassesMap(AdvancedCache<?, ?> cache) {
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        HashMap entities = new HashMap();
        for (Class c : cacheConfiguration.indexing().indexedEntities()) {
            entities.put(c.getName(), c);
        }
        if (!cache.getValueDataConversion().getStorageMediaType().match(MediaType.APPLICATION_PROTOSTREAM)) {
            for (String typeName : cacheConfiguration.indexing().indexedEntityTypes()) {
                if (entities.containsKey(typeName)) continue;
                try {
                    Class c = Util.loadClass((String)typeName, (ClassLoader)cache.getClassLoader());
                    entities.put(c.getName(), c);
                }
                catch (Exception e) {
                    throw new CacheConfigurationException("Failed to load declared indexed class", (Throwable)e);
                }
            }
        }
        return entities;
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, AdvancedCache<?, ?> cache, Map<String, Class<?>> indexedClasses, KeyTransformationHandler keyTransformationHandler) {
        Log.CONTAINER.registeringQueryInterceptor(cache.getName());
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        ComponentRef queryInterceptorRef = bcr.getComponent(QueryInterceptor.class);
        if (queryInterceptorRef != null) {
            return;
        }
        ConcurrentHashMap<GlobalTransaction, Map<Object, Object>> txOldValues = new ConcurrentHashMap<GlobalTransaction, Map<Object, Object>>();
        boolean manualIndexing = HS5_CONF_STRATEGY_MANUAL.equals(cfg.indexing().properties().get((Object)HS5_CONF_STRATEGY_PROPERTY));
        QueryInterceptor queryInterceptor = new QueryInterceptor(keyTransformationHandler, manualIndexing, txOldValues, cache, indexedClasses);
        for (Map.Entry kt : cfg.indexing().keyTransformers().entrySet()) {
            keyTransformationHandler.registerTransformer((Class)kt.getKey(), (Class)kt.getValue());
        }
        AsyncInterceptorChain ic = (AsyncInterceptorChain)bcr.getComponent(AsyncInterceptorChain.class).wired();
        EntryWrappingInterceptor wrappingInterceptor = (EntryWrappingInterceptor)ic.findInterceptorExtending(EntryWrappingInterceptor.class);
        AsyncInterceptor lastLoadingInterceptor = ic.findInterceptorExtending(CacheLoaderInterceptor.class);
        if (lastLoadingInterceptor == null) {
            lastLoadingInterceptor = wrappingInterceptor;
        }
        ic.addInterceptorAfter((AsyncInterceptor)queryInterceptor, lastLoadingInterceptor.getClass());
        bcr.registerComponent(QueryInterceptor.class, (Object)queryInterceptor, true);
        bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), QueryInterceptor.class.getName());
        if (cfg.transaction().transactionMode().isTransactional()) {
            TxQueryInterceptor txQueryInterceptor = new TxQueryInterceptor(txOldValues, queryInterceptor);
            ic.addInterceptorBefore((AsyncInterceptor)txQueryInterceptor, wrappingInterceptor.getClass());
            bcr.registerComponent(TxQueryInterceptor.class, (Object)txQueryInterceptor, true);
            bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), TxQueryInterceptor.class.getName());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        IndexingConfiguration indexingConfiguration = configuration.indexing();
        if (!indexingConfiguration.enabled()) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        SearchMapping searchMapping = (SearchMapping)cr.getComponent(SearchMapping.class);
        if (searchMapping != null) {
            this.checkIndexableClasses(searchMapping, indexingConfiguration.indexedEntities());
        }
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        Indexer massIndexer = ComponentRegistryUtils.getIndexer(cache);
        InfinispanQueryStatisticsInfo stats = new InfinispanQueryStatisticsInfo(Search.getSearchStatistics(cache));
        cr.registerComponent((Object)stats, InfinispanQueryStatisticsInfo.class);
        this.registerQueryMBeans(cr, massIndexer, stats);
        this.registerMetrics(cr, stats);
    }

    private void registerMetrics(ComponentRegistry cr, InfinispanQueryStatisticsInfo stats) {
        CacheMetricsRegistration cacheMetricsRegistration = (CacheMetricsRegistration)cr.getComponent(CacheMetricsRegistration.class);
        if (cacheMetricsRegistration.metricsEnabled()) {
            cacheMetricsRegistration.registerMetrics((Object)stats, "query", "statistics");
        }
    }

    private void checkIndexableClasses(SearchMapping searchMapping, Set<Class<?>> indexedEntities) {
        if (indexedEntities.isEmpty()) {
            return;
        }
        Collection<Class<?>> indexedTypes = searchMapping.allIndexedTypes().values();
        for (Class<?> c : indexedEntities) {
            if (indexedTypes.contains(c)) continue;
            throw Log.CONTAINER.classNotIndexable(c.getName());
        }
    }

    private void registerQueryMBeans(ComponentRegistry cr, Indexer massIndexer, InfinispanQueryStatisticsInfo stats) {
        GlobalConfiguration globalConfig = cr.getGlobalComponentRegistry().getGlobalConfiguration();
        if (globalConfig.jmx().enabled()) {
            Cache cache = (Cache)cr.getComponent(Cache.class);
            String queryGroupName = this.getQueryGroupName(globalConfig.cacheManagerName(), cache.getName());
            CacheJmxRegistration jmxRegistration = (CacheJmxRegistration)cr.getComponent(CacheJmxRegistration.class);
            try {
                jmxRegistration.registerMBean((Object)stats, queryGroupName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to register query statistics MBean", (Throwable)e);
            }
            try {
                jmxRegistration.registerMBean((Object)massIndexer, queryGroupName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to register MassIndexer MBean", (Throwable)e);
            }
        }
    }

    private String getQueryGroupName(String cacheManagerName, String cacheName) {
        return "type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        AsyncInterceptorChain interceptorChain = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        return interceptorChain != null && interceptorChain.containsInterceptorType(QueryInterceptor.class, true);
    }

    private SearchMapping createSearchMapping(LocalQueryStatistics queryStatistics, IndexingConfiguration indexingConfiguration, Map<String, Class<?>> indexedClasses, ComponentRegistry cr, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, ClassLoader aggregatedClassLoader) {
        SearchMapping searchMapping = (SearchMapping)cr.getComponent(SearchMapping.class);
        if (searchMapping != null && !searchMapping.isClose()) {
            throw new IllegalStateException("SearchIntegrator already initialized!");
        }
        Collection mappingProviders = ServiceFinder.load(ProgrammaticSearchMappingProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader});
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Collection analyzerDefProviders = ServiceFinder.load(LuceneAnalysisConfigurer.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader});
        if (analyzerDefProviders.size() == 1) {
            properties.put(ANALYSIS_CONFIGURER_PROPERTY_NAME, analyzerDefProviders.iterator().next());
        } else if (!analyzerDefProviders.isEmpty()) {
            properties.put(ANALYSIS_CONFIGURER_PROPERTY_NAME, new CompositeAnalysisConfigurer(analyzerDefProviders));
        }
        for (Map.Entry entry : indexingConfiguration.properties().entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            if (!(entry.getKey() instanceof String)) {
                throw log.invalidPropertyKey(entry.getKey());
            }
            properties.put((String)entry.getKey(), entry.getValue());
        }
        SearchMappingCommonBuilding commonBuilding = new SearchMappingCommonBuilding(CacheIdentifierBridge.getReference(), properties, aggregatedClassLoader, mappingProviders);
        HashSet types = new HashSet(indexedClasses.values());
        if (!types.isEmpty()) {
            SearchMappingBuilder builder = commonBuilding.builder(SearchMappingBuilder.introspector(MethodHandles.lookup()));
            builder.setEntityLoader(new EntityLoader(queryStatistics, cache, keyTransformationHandler));
            builder.addEntityTypes(types);
            searchMapping = builder.build();
            if (searchMapping != null) {
                cr.registerComponent((Object)searchMapping, SearchMapping.class);
            }
        }
        if (searchMapping == null) {
            cr.registerComponent((Object)commonBuilding, SearchMappingCommonBuilding.class);
        }
        return searchMapping;
    }

    private ClassLoader makeAggregatedClassLoader(ClassLoader globalClassLoader) {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>(6);
        if (globalClassLoader != null) {
            classLoaders.add(globalClassLoader);
        }
        classLoaders.add(AggregatedClassLoader.class.getClassLoader());
        classLoaders.add(this.getClass().getClassLoader());
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                classLoaders.add(tccl);
            }
        }
        catch (Exception tccl) {
            // empty catch block
        }
        try {
            ClassLoader syscl = ClassLoader.getSystemClassLoader();
            if (syscl != null) {
                classLoaders.add(syscl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AggregatedClassLoader(classLoaders);
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        SearchMapping searchMapping;
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor != null) {
            queryInterceptor.prepareForStopping();
        }
        if ((searchMapping = (SearchMapping)cr.getComponent(SearchMapping.class)) != null) {
            searchMapping.close();
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        InternalCacheRegistry icr;
        QueryCache queryCache = (QueryCache)cr.getComponent(QueryCache.class);
        if (queryCache != null && (!(icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class)).isInternalCache(cacheName) || icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.QUERYABLE))) {
            queryCache.clear(cacheName);
        }
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.LUCENE_SORT, new LuceneSortExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT_FIELD, new LuceneSortFieldExternalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_TOPDOCS, new NodeTopDocs.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPDOCS, new LuceneTopDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_FIELD_SCORE_DOC, new LuceneFieldDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SCORE_DOC, new LuceneScoreDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPFIELDDOCS, new LuceneTopFieldDocsExternalizer());
        externalizerMap.put(ExternalizerIds.INDEX_WORKER, new IndexWorker.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_BYTES_REF, new LuceneBytesRefExternalizer());
        externalizerMap.put(ExternalizerIds.QUERY_DEFINITION, new QueryDefinition.Externalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_COMMAND_RESPONSE, new QueryResponse.Externalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_OPERATION, new ClusteredQueryOperation.Externalizer());
        externalizerMap.put(ExternalizerIds.POJO_TYPE_IDENTIFIER, new PojoRawTypeIdentifierExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOTAL_HITS, new LuceneTotalHitsExternalizer());
    }

    private void setBooleanQueryMaxClauseCount(TypedProperties properties) {
        if (!maxBooleanClausesWasSet) {
            maxBooleanClausesWasSet = true;
            String maxClauseCountProp = properties.getProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP);
            if (maxClauseCountProp == null) {
                maxClauseCountProp = SecurityActions.getSystemProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP);
            }
            if (maxClauseCountProp != null) {
                int maxClauseCount;
                try {
                    maxClauseCount = Integer.parseInt(maxClauseCountProp);
                }
                catch (NumberFormatException e) {
                    Log.CONTAINER.failedToParseSystemProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP, e);
                    throw e;
                }
                int currentMaxClauseCount = BooleanQuery.getMaxClauseCount();
                if (maxClauseCount > currentMaxClauseCount) {
                    Log.CONTAINER.settingBooleanQueryMaxClauseCount(MAX_BOOLEAN_CLAUSES_SYS_PROP, maxClauseCount);
                    BooleanQuery.setMaxClauseCount((int)maxClauseCount);
                } else {
                    Log.CONTAINER.ignoringBooleanQueryMaxClauseCount(MAX_BOOLEAN_CLAUSES_SYS_PROP, maxClauseCount, currentMaxClauseCount);
                }
            }
        }
    }
}

