/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.infinispan.search.mapper.mapping.impl.DefaultAnalysisConfigurer;

public class IndexProperties {
    private static final String INFINISPAN_BACKEND_NAME = "infinispan_backend";
    private static final String BACKEND_PROPERTIES_PREFIX = "hibernate.search.backends.infinispan_backend";
    private final Map<String, Object> engineProperties = new HashMap<String, Object>();
    private final Map<String, Object> backendProperties = new HashMap<String, Object>();

    public void setProperty(String key, Object value) {
        if (key.startsWith("hibernate.search.")) {
            this.engineProperties.put(key, value);
        } else {
            this.backendProperties.put(key, value);
        }
    }

    public void setProperties(Map<String, Object> properties) {
        properties.entrySet().stream().forEach(property -> this.setProperty((String)property.getKey(), property.getValue()));
    }

    public ConfigurationPropertySource createPropertySource(ConfigurationPropertyChecker propertyChecker) {
        ConfigurationPropertySource basePropertySource = propertyChecker.wrap(ConfigurationPropertySource.fromMap(this.backendProperties)).withPrefix(BACKEND_PROPERTIES_PREFIX);
        ConfigurationPropertySource propertySource = basePropertySource.withOverride((ConfigurationPropertySource)ConfigurationPropertySource.fromMap(this.engineProperties));
        this.defaultProperties();
        return propertySource;
    }

    private void defaultProperties() {
        this.engineProperties.put("hibernate.search.default_backend", INFINISPAN_BACKEND_NAME);
        this.backendProperties.put("type", "lucene");
        this.backendProperties.put("analysis.configurer", new DefaultAnalysisConfigurer());
        this.backendProperties.put("thread_pool.size", "1");
        this.backendProperties.put("index_defaults.indexing.queue_count", "1");
    }
}

