/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.EngineConfigTest")
public class EngineConfigTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).storage(IndexStorage.FILESYSTEM).path("${java.io.tmpdir}/baseDir").reader().refreshInterval(5000L).writer().commitInterval(2000).ramBufferSize(40).queueSize(555).queueCount(8).threadPoolSize(11).setLowLevelTrace(true).maxBufferedDocs(50000).merge().maxSize(1500).factor(30).calibrateByDeletes(true).minSize(100).maxForcedSize(110).maxDocs(12000);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    @Test
    public void testPropertiesGeneration() {
        this.cache.put((Object)1, (Object)new Person("name", "blurb", 12));
        TypedProperties properties = this.cache.getCacheConfiguration().indexing().properties();
        AssertJUnit.assertEquals((Object)"local-filesystem", (Object)properties.get((Object)"hibernate.search.backend.directory.type"));
        AssertJUnit.assertEquals((Object)(System.getProperty("java.io.tmpdir") + "/baseDir"), (Object)properties.get((Object)"hibernate.search.backend.directory.root"));
        AssertJUnit.assertEquals((Object)5000L, (Object)properties.get((Object)"hibernate.search.backend.io.refresh_interval"));
        AssertJUnit.assertEquals((Object)2000, (Object)properties.get((Object)"hibernate.search.backend.io.commit_interval"));
        AssertJUnit.assertEquals((Object)40, (Object)properties.get((Object)"hibernate.search.backend.io.writer.ram_buffer_size"));
        AssertJUnit.assertEquals((Object)555, (Object)properties.get((Object)"hibernate.search.backend.indexing.queue_size"));
        AssertJUnit.assertEquals((Object)8, (Object)properties.get((Object)"hibernate.search.backend.indexing.queue_count"));
        AssertJUnit.assertEquals((Object)11, (Object)properties.get((Object)"hibernate.search.backend.thread_pool.size"));
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)properties.get((Object)"hibernate.search.backend.io.writer.infostream"));
        AssertJUnit.assertEquals((Object)50000, (Object)properties.get((Object)"hibernate.search.backend.io.writer.max_buffered_docs"));
        AssertJUnit.assertEquals((Object)1500, (Object)properties.get((Object)"hibernate.search.backend.io.merge.max_size"));
        AssertJUnit.assertEquals((Object)30, (Object)properties.get((Object)"hibernate.search.backend.io.merge.factor"));
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)properties.get((Object)"hibernate.search.backend.io.merge.calibrate_by_deletes"));
        AssertJUnit.assertEquals((Object)100, (Object)properties.get((Object)"hibernate.search.backend.io.merge.min_size"));
        AssertJUnit.assertEquals((Object)110, (Object)properties.get((Object)"hibernate.search.backend.io.merge.max_forced_size"));
        AssertJUnit.assertEquals((Object)12000, (Object)properties.get((Object)"hibernate.search.backend.io.merge.max_docs"));
    }
}

