/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.QueryStatistics;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.query.test.Transaction;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.StatsTest")
public class StatsTest
extends MultipleCacheManagersTest {
    private Cache<String, Object> cache0;
    private Cache<String, Object> cache1;
    private Cache<String, Object> cache2;
    private QueryStatistics queryStatistics0;
    private QueryStatistics queryStatistics1;
    private QueryStatistics queryStatistics2;
    private String indexedQuery;
    private String nonIndexedQuery;
    private String hybridQuery;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = StatsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.statistics().enable();
        cacheCfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Person.class).addIndexedEntity(Transaction.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.createClusteredCaches(3, QueryTestSCI.INSTANCE, cacheCfg);
        this.cache0 = this.cache(0);
        this.cache1 = this.cache(1);
        this.cache2 = this.cache(2);
        this.queryStatistics0 = Search.getSearchStatistics(this.cache0).getQueryStatistics();
        this.queryStatistics1 = Search.getSearchStatistics(this.cache1).getQueryStatistics();
        this.queryStatistics2 = Search.getSearchStatistics(this.cache2).getQueryStatistics();
        this.indexedQuery = String.format("From %s where name : 'Donald'", Person.class.getName());
        this.nonIndexedQuery = String.format("From %s where nonIndexedField = 'first'", Person.class.getName());
        this.hybridQuery = String.format("From %s where nonIndexedField = 'first' and age > 50", Person.class.getName());
    }

    @BeforeMethod
    public void setUp() {
        this.cache0.clear();
        this.addData();
    }

    @Test
    public void testQueryStats() {
        this.testNonIndexedQueryStats();
        this.testIndexedQueryStats();
        this.testHybridQueryStats();
        this.testClean();
    }

    @Test
    public void testIndexStats() {
        HashSet<String> expectedEntities = new HashSet<String>(Arrays.asList(Person.class.getName(), Transaction.class.getName()));
        int expectDocuments = this.cacheManagers.size() * this.cache0.getCacheConfiguration().clustering().hash().numOwners();
        HashSet totalEntities = new HashSet();
        int totalCount = 0;
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            SearchStatistics searchStatistics = Search.getSearchStatistics((Cache)this.cache(i));
            Map indexInfos = searchStatistics.getIndexStatistics().indexInfos();
            totalEntities.addAll(indexInfos.keySet());
            for (IndexInfo indexInfo : indexInfos.values()) {
                totalCount = (int)((long)totalCount + indexInfo.count());
            }
        }
        Assert.assertEquals(totalEntities, expectedEntities);
        Assert.assertEquals((int)totalCount, (int)expectDocuments);
        SearchStatistics clusteredStats = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache0));
        Map classIndexInfoMap = clusteredStats.getIndexStatistics().indexInfos();
        Assert.assertEquals(classIndexInfoMap.keySet(), expectedEntities);
        Long reduce = classIndexInfoMap.values().stream().map(IndexInfo::count).reduce(0L, Long::sum);
        int i = this.cacheManagers.size() * this.cache0.getCacheConfiguration().clustering().hash().numOwners();
        Assert.assertEquals((int)reduce.intValue(), (int)i);
    }

    private void testClean() {
        this.queryStatistics0.clear();
        this.queryStatistics1.clear();
        this.queryStatistics2.clear();
        SearchStatistics clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache0));
        QueryStatistics localQueryStatistics = clustered.getQueryStatistics();
        Assert.assertEquals((long)localQueryStatistics.getNonIndexedQueryCount(), (long)0L);
        Assert.assertEquals((long)localQueryStatistics.getHybridQueryCount(), (long)0L);
        Assert.assertEquals((long)localQueryStatistics.getDistributedIndexedQueryCount(), (long)0L);
        Assert.assertEquals((long)localQueryStatistics.getLocalIndexedQueryCount(), (long)0L);
    }

    private void testNonIndexedQueryStats() {
        this.executeQuery(this.nonIndexedQuery, this.cache0);
        Assert.assertEquals((long)this.queryStatistics0.getNonIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getNonIndexedQueryCount(), (long)0L);
        Assert.assertEquals((long)this.queryStatistics2.getNonIndexedQueryCount(), (long)0L);
        SearchStatistics clustered1 = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered1.getQueryStatistics().getNonIndexedQueryCount(), (long)1L);
        this.executeQuery(this.nonIndexedQuery, this.cache1);
        Assert.assertEquals((long)this.queryStatistics0.getNonIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getNonIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getNonIndexedQueryCount(), (long)0L);
        SearchStatistics clustered2 = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache2));
        Assert.assertEquals((long)clustered2.getQueryStatistics().getNonIndexedQueryCount(), (long)2L);
        this.executeQuery(this.nonIndexedQuery, this.cache2);
        Assert.assertEquals((long)this.queryStatistics0.getNonIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getNonIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getNonIndexedQueryCount(), (long)1L);
        SearchStatistics clustered0 = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache0));
        Assert.assertEquals((long)clustered0.getQueryStatistics().getNonIndexedQueryCount(), (long)3L);
    }

    private void testIndexedQueryStats() {
        this.executeQuery(this.indexedQuery, this.cache0);
        Assert.assertEquals((long)this.queryStatistics0.getLocalIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics0.getDistributedIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getLocalIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getDistributedIndexedQueryCount(), (long)0L);
        Assert.assertEquals((long)this.queryStatistics2.getLocalIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getDistributedIndexedQueryCount(), (long)0L);
        SearchStatistics clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered.getQueryStatistics().getLocalIndexedQueryCount(), (long)3L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getDistributedIndexedQueryCount(), (long)1L);
        this.executeQuery(this.indexedQuery, this.cache1);
        Assert.assertEquals((long)this.queryStatistics0.getLocalIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics0.getDistributedIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getLocalIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics1.getDistributedIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getLocalIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics2.getDistributedIndexedQueryCount(), (long)0L);
        clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered.getQueryStatistics().getLocalIndexedQueryCount(), (long)6L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getDistributedIndexedQueryCount(), (long)2L);
        this.executeQuery(this.indexedQuery, this.cache2);
        Assert.assertEquals((long)this.queryStatistics0.getLocalIndexedQueryCount(), (long)3L);
        Assert.assertEquals((long)this.queryStatistics0.getDistributedIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getLocalIndexedQueryCount(), (long)3L);
        Assert.assertEquals((long)this.queryStatistics1.getDistributedIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getLocalIndexedQueryCount(), (long)3L);
        Assert.assertEquals((long)this.queryStatistics2.getDistributedIndexedQueryCount(), (long)1L);
        clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered.getQueryStatistics().getLocalIndexedQueryCount(), (long)9L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getDistributedIndexedQueryCount(), (long)3L);
    }

    private void testHybridQueryStats() {
        this.executeQuery(this.hybridQuery, this.cache0);
        Assert.assertEquals((long)this.queryStatistics0.getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics0.getLocalIndexedQueryCount(), (long)4L);
        Assert.assertEquals((long)this.queryStatistics0.getDistributedIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics1.getHybridQueryCount(), (long)0L);
        Assert.assertEquals((long)this.queryStatistics1.getLocalIndexedQueryCount(), (long)4L);
        Assert.assertEquals((long)this.queryStatistics1.getDistributedIndexedQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getHybridQueryCount(), (long)0L);
        Assert.assertEquals((long)this.queryStatistics2.getLocalIndexedQueryCount(), (long)4L);
        Assert.assertEquals((long)this.queryStatistics2.getDistributedIndexedQueryCount(), (long)1L);
        SearchStatistics clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered.getQueryStatistics().getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getLocalIndexedQueryCount(), (long)12L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getDistributedIndexedQueryCount(), (long)4L);
        this.executeQuery(this.hybridQuery, this.cache1);
        Assert.assertEquals((long)this.queryStatistics0.getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics0.getLocalIndexedQueryCount(), (long)5L);
        Assert.assertEquals((long)this.queryStatistics0.getDistributedIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics1.getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getLocalIndexedQueryCount(), (long)5L);
        Assert.assertEquals((long)this.queryStatistics1.getDistributedIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics2.getHybridQueryCount(), (long)0L);
        Assert.assertEquals((long)this.queryStatistics2.getLocalIndexedQueryCount(), (long)5L);
        Assert.assertEquals((long)this.queryStatistics2.getDistributedIndexedQueryCount(), (long)1L);
        clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered.getQueryStatistics().getHybridQueryCount(), (long)2L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getLocalIndexedQueryCount(), (long)15L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getDistributedIndexedQueryCount(), (long)5L);
        this.executeQuery(this.hybridQuery, this.cache2);
        Assert.assertEquals((long)this.queryStatistics0.getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics0.getLocalIndexedQueryCount(), (long)6L);
        Assert.assertEquals((long)this.queryStatistics0.getDistributedIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics1.getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics1.getLocalIndexedQueryCount(), (long)6L);
        Assert.assertEquals((long)this.queryStatistics1.getDistributedIndexedQueryCount(), (long)2L);
        Assert.assertEquals((long)this.queryStatistics2.getHybridQueryCount(), (long)1L);
        Assert.assertEquals((long)this.queryStatistics2.getLocalIndexedQueryCount(), (long)6L);
        Assert.assertEquals((long)this.queryStatistics2.getDistributedIndexedQueryCount(), (long)2L);
        clustered = (SearchStatistics)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics(this.cache1));
        Assert.assertEquals((long)clustered.getQueryStatistics().getHybridQueryCount(), (long)3L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getLocalIndexedQueryCount(), (long)18L);
        Assert.assertEquals((long)clustered.getQueryStatistics().getDistributedIndexedQueryCount(), (long)6L);
    }

    private void executeQuery(String q, Cache<String, Object> fromCache) {
        List list = Search.getQueryFactory(fromCache).create(q).execute().list();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    private void addData() {
        Person person1 = new Person("Donald", "Duck", 86);
        person1.setNonIndexedField("second");
        Person person2 = new Person("Mickey", "Mouse", 92);
        person2.setNonIndexedField("first");
        this.cache0.put((Object)"1", (Object)person1);
        this.cache0.put((Object)"2", (Object)person2);
        this.cache0.put((Object)"3", (Object)new Transaction(12, "sss"));
    }
}

