/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.infinispan.search.mapper.mapping.impl.InfinispanIndexedTypeContextImpl;
import org.infinispan.search.mapper.session.impl.InfinispanIndexedTypeContext;
import org.infinispan.search.mapper.session.impl.InfinispanTypeContextProvider;

class InfinispanTypeContextContainer
implements InfinispanTypeContextProvider {
    private final Map<String, InfinispanIndexedTypeContextImpl<?>> indexedTypeContextsByEntityName = new LinkedHashMap();
    private final Map<Class<?>, InfinispanIndexedTypeContextImpl<?>> indexedTypeContextsByJavaType = new LinkedHashMap();

    private InfinispanTypeContextContainer(Builder builder) {
        for (InfinispanIndexedTypeContextImpl.Builder contextBuilder : builder.indexedTypeContextBuilders) {
            InfinispanIndexedTypeContextImpl indexedTypeContext = contextBuilder.build();
            this.indexedTypeContextsByEntityName.put(indexedTypeContext.getEntityName(), indexedTypeContext);
            this.indexedTypeContextsByJavaType.put(indexedTypeContext.getTypeIdentifier().javaClass(), indexedTypeContext);
        }
    }

    @Override
    public InfinispanIndexedTypeContext<?> getTypeContextByEntityType(Class<?> entityType) {
        return this.indexedTypeContextsByJavaType.get(entityType);
    }

    @Override
    public InfinispanIndexedTypeContext<?> getTypeContextByEntityName(String indexName) {
        return this.indexedTypeContextsByEntityName.get(indexName);
    }

    @Override
    public Map<String, Class<?>> getEntityClassByEntityName() {
        Map<String, InfinispanIndexedTypeContextImpl<?>> indexedTypeContextsByEntityName = this.indexedTypeContextsByEntityName;
        return indexedTypeContextsByEntityName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, w -> ((InfinispanIndexedTypeContextImpl)w.getValue()).javaClass()));
    }

    @Override
    public Collection<PojoRawTypeIdentifier<?>> allTypeIdentifiers() {
        return this.indexedTypeContextsByEntityName.values().stream().map(InfinispanIndexedTypeContextImpl::getTypeIdentifier).collect(Collectors.toList());
    }

    InfinispanIndexedTypeContextImpl<?> getIndexedByEntityType(Class<?> entityType) {
        return this.indexedTypeContextsByJavaType.get(entityType);
    }

    InfinispanIndexedTypeContextImpl<?> getIndexedByEntityName(String indexName) {
        return this.indexedTypeContextsByEntityName.get(indexName);
    }

    Collection<InfinispanIndexedTypeContextImpl<?>> getAllIndexed() {
        return this.indexedTypeContextsByJavaType.values();
    }

    static class Builder {
        private final List<InfinispanIndexedTypeContextImpl.Builder<?>> indexedTypeContextBuilders = new ArrayList();

        Builder() {
        }

        <E> InfinispanIndexedTypeContextImpl.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String entityName) {
            InfinispanIndexedTypeContextImpl.Builder builder = new InfinispanIndexedTypeContextImpl.Builder(typeModel.typeIdentifier(), entityName);
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        InfinispanTypeContextContainer build() {
            return new InfinispanTypeContextContainer(this);
        }
    }
}

