/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.IOException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.IndexAccessor;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.QueryInterceptorIndexingOperationsTest")
public class QueryInterceptorIndexingOperationsTest
extends SingleCacheManagerTest {
    public QueryInterceptorIndexingOperationsTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testAvoidUnnecessaryRemoveForSimpleUpdate() throws Exception {
        Directory directory = this.initializeAndExtractDirectory(this.cache, Entity1.class);
        Entity1 entity1 = new Entity1("e1");
        this.cache.put((Object)1, (Object)entity1);
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, (Cache<Object, Object>)this.cache, () -> this.cache.put((Object)1, (Object)new Entity1("e2")));
        AssertJUnit.assertEquals((long)1L, (long)commits);
        AssertJUnit.assertEquals((long)1L, (long)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((long)0L, (long)this.countIndexedDocuments(Entity2.class));
    }

    public void testOverrideNonIndexedByIndexed() throws Exception {
        Directory directory = this.initializeAndExtractDirectory(this.cache, Entity1.class);
        this.cache.put((Object)1, (Object)"string value");
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, (Cache<Object, Object>)this.cache, () -> this.cache.put((Object)1, (Object)new Entity1("e1")));
        AssertJUnit.assertEquals((long)1L, (long)commits);
        AssertJUnit.assertEquals((long)1L, (long)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((long)0L, (long)this.countIndexedDocuments(Entity2.class));
    }

    public void testOverrideIndexedByNonIndexed() throws Exception {
        Directory directory = this.initializeAndExtractDirectory(this.cache, Entity1.class);
        Entity1 entity1 = new Entity1("title");
        this.cache.put((Object)1, (Object)entity1);
        long commits = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory, (Cache<Object, Object>)this.cache, () -> this.cache.put((Object)1, (Object)"another"));
        AssertJUnit.assertEquals((long)1L, (long)commits);
        AssertJUnit.assertEquals((long)0L, (long)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((long)0L, (long)this.countIndexedDocuments(Entity2.class));
    }

    public void testOverrideIndexedByOtherIndexed() throws Exception {
        Directory directory1 = this.initializeAndExtractDirectory(this.cache, Entity1.class);
        Directory directory2 = this.initializeAndExtractDirectory(this.cache, Entity2.class);
        Entity1 entity1 = new Entity1("title");
        this.cache.put((Object)1, (Object)entity1);
        long initialGenDir1 = SegmentInfos.getLastCommitGeneration((Directory)directory1);
        long commitsDir2 = QueryInterceptorIndexingOperationsTest.doRecordingCommits(directory2, (Cache<Object, Object>)this.cache, () -> this.cache.put((Object)1, (Object)new Entity2("title2")));
        long commitsDir1 = SegmentInfos.getLastCommitGeneration((Directory)directory1) - initialGenDir1;
        AssertJUnit.assertEquals((long)3L, (long)(commitsDir1 + commitsDir2));
        AssertJUnit.assertEquals((long)0L, (long)this.countIndexedDocuments(Entity1.class));
        AssertJUnit.assertEquals((long)1L, (long)this.countIndexedDocuments(Entity2.class));
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.indexing().enable().addIndexedEntity(Entity1.class).addIndexedEntity(Entity2.class).addProperty("directory.type", "local-heap");
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().clusteredDefault().defaultCacheName("defaultcache").serialization().addContextInitializer((SerializationContextInitializer)QueryTestSCI.INSTANCE);
        holder.getNamedConfigurationBuilders().put("defaultcache", builder);
        return TestCacheManagerFactory.newDefaultCacheManager((boolean)true, (ConfigurationBuilderHolder)holder);
    }

    static long doRecordingCommits(Directory directory, Cache<Object, Object> cache, Operation operation) throws IOException {
        long initialGen = SegmentInfos.getLastCommitGeneration((Directory)directory);
        if (initialGen == -1L) {
            initialGen = 0L;
        }
        operation.execute();
        TestQueryHelperFactory.extractSearchMapping(cache).scopeAll().workspace().flush();
        return SegmentInfos.getLastCommitGeneration((Directory)directory) - initialGen;
    }

    private Directory initializeAndExtractDirectory(Cache cache, Class<?> entityType) {
        return IndexAccessor.of(cache, entityType).getDirectory();
    }

    private long countIndexedDocuments(Class<?> clazz) {
        Query query = Search.getQueryFactory((Cache)this.cache).create("FROM " + clazz.getName());
        return query.execute().hitCount().orElse(-1L);
    }

    @Indexed(index="theIndex2")
    public static class Entity2 {
        @Field
        private final String attribute;

        public Entity2(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }
    }

    @Indexed(index="theIndex1")
    public static class Entity1 {
        @Field
        private final String attribute;

        public Entity1(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }
    }

    static interface Operation {
        public void execute();
    }
}

