/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.IndexAccessor;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.OffHeapQueryTest")
public class OffHeapQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.memory().storageType(StorageType.OFF_HEAP).size(10L);
        cfg.indexing().enable().addIndexedEntity(Person.class).addProperty("directory.type", "local-heap");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @Test
    public void testQuery() throws Exception {
        this.cache.put((Object)"1", (Object)new Person("Donald", "MAGA", 78));
        Assert.assertEquals((long)this.getIndexDocs(), (long)1L);
        Query queryFromLucene = TestQueryHelperFactory.createCacheQuery(Person.class, this.cache, "name", "Donald");
        Assert.assertEquals((int)1, (int)queryFromLucene.execute().list().size());
        Query queryFromIckle = Search.getQueryFactory((Cache)this.cache).create("From org.infinispan.query.test.Person p where p.name:'Donald'");
        Assert.assertEquals((int)1, (int)queryFromIckle.execute().list().size());
    }

    private long getIndexDocs() throws IOException {
        return IndexAccessor.of(this.cache, Person.class).getIndexReader().numDocs();
    }
}

