/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.distributed.NonSerializableKeyType;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DistributedMassIndexingTest")
public class DistributedMassIndexingTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 3;

    public DistributedMassIndexingTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected String getConfigurationFile() {
        return "dynamic-indexing-distribution.xml";
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 3; ++i) {
            EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)this.getConfigurationFile());
            this.registerCacheManager(new CacheContainer[]{cacheManager});
            cacheManager.getCache();
        }
        this.waitForClusterToForm();
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        super.clearContent();
    }

    public void testReindexing() throws Exception {
        this.cache(0).put(this.key("F1NUM"), (Object)new Car("megane", "white", 300));
        this.verifyFindsCar(1, "megane");
        this.cache(1).put(this.key("F2NUM"), (Object)new Car("megane", "blue", 300));
        this.verifyFindsCar(2, "megane");
        this.cache(1).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("F3NUM"), (Object)new Car("megane", "blue", 300));
        this.verifyFindsCar(2, "megane");
        this.rebuildIndexes();
        this.verifyFindsCar(3, "megane");
        this.cache(2).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).remove(this.key("F2NUM"));
        this.verifyFindsCar(3, "megane");
        this.rebuildIndexes();
        this.verifyFindsCar(2, "megane");
    }

    public void testPartiallyReindex() throws Exception {
        this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("F1NUM"), (Object)new Car("megane", "white", 300));
        Search.getIndexer((Cache)this.cache(0)).run(new Object[]{this.key("F1NUM")}).toCompletableFuture().join();
        this.verifyFindsCar(1, "megane");
        this.cache(0).remove(this.key("F1NUM"));
        this.verifyFindsCar(0, "megane");
    }

    protected Object key(String keyId) {
        return new NonSerializableKeyType(keyId);
    }

    protected void rebuildIndexes() throws Exception {
        Cache cache = this.cache(0);
        CompletionStages.join((CompletionStage)Search.getIndexer((Cache)cache).run());
    }

    protected void verifyFindsCar(int expectedCount, String carMake) {
        for (Cache cache : this.caches()) {
            StaticTestingErrorHandler.assertAllGood(cache);
            this.verifyFindsCar(cache, expectedCount, carMake);
        }
    }

    protected void verifyFindsCar(Cache<?, Car> cache, int expectedCount, String carMake) {
        String q = String.format("FROM %s where make:'%s'", Car.class.getName(), carMake);
        Query cacheQuery = Search.getQueryFactory(cache).create(q);
        AssertJUnit.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
    }
}

