/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.query.dsl.embedded.DslSCI;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.ClusteredQueryDslConditionsTest")
public class ClusteredQueryDslConditionsTest
extends QueryDslConditionsTest {
    protected static final String TEST_CACHE_NAME = "custom";
    protected Cache<Object, Object> cache1;
    protected Cache<Object, Object> cache2;

    protected Cache<Object, Object> getCacheForWrite() {
        return this.cache1;
    }

    protected Cache<Object, Object> getCacheForQuery() {
        return this.cache2;
    }

    protected Map<String, String> getIndexConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("directory.type", "local-heap");
        return configs;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfiguration = ClusteredQueryDslConditionsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        defaultConfiguration.clustering().stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(2, DslSCI.INSTANCE, defaultConfiguration);
        ConfigurationBuilder cfg = this.initialCacheConfiguration();
        IndexingConfigurationBuilder indexingConfigurationBuilder = cfg.clustering().stateTransfer().fetchInMemoryState(true).indexing().enable().addIndexedEntity(this.getModelFactory().getUserImplClass()).addIndexedEntity(this.getModelFactory().getAccountImplClass()).addIndexedEntity(this.getModelFactory().getTransactionImplClass());
        this.getIndexConfig().forEach((arg_0, arg_1) -> ((IndexingConfigurationBuilder)indexingConfigurationBuilder).addProperty(arg_0, arg_1));
        this.manager(0).defineConfiguration(TEST_CACHE_NAME, cfg.build());
        this.manager(1).defineConfiguration(TEST_CACHE_NAME, cfg.build());
        this.cache1 = this.manager(0).getCache(TEST_CACHE_NAME);
        this.cache2 = this.manager(1).getCache(TEST_CACHE_NAME);
    }

    protected ConfigurationBuilder initialCacheConfiguration() {
        return ClusteredQueryDslConditionsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
    }

    @Override
    public void testIndexPresence() {
        this.checkIndexPresence(this.cache1);
        this.checkIndexPresence(this.cache2);
    }

    private void checkIndexPresence(Cache<?, ?> cache) {
        SearchMapping searchMapping = TestQueryHelperFactory.extractSearchMapping(cache);
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getUserImplClass());
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getAccountImplClass());
        this.verifyClassIsIndexed(searchMapping, this.getModelFactory().getTransactionImplClass());
        this.verifyClassIsNotIndexed(searchMapping, this.getModelFactory().getAddressImplClass());
    }

    private void verifyClassIsNotIndexed(SearchMapping searchMapping, Class<?> type) {
        AssertionsForInterfaceTypes.assertThat((Map)searchMapping.allIndexedTypes()).doesNotContainValue(type);
    }

    private void verifyClassIsIndexed(SearchMapping searchMapping, Class<?> type) {
        AssertionsForInterfaceTypes.assertThat((Map)searchMapping.allIndexedTypes()).containsValue(type);
    }
}

