/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexedembedded;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.indexedembedded.CollectionsIndexingTest")
public class CollectionsIndexingTest
extends SingleCacheManagerTest {
    private QueryFactory queryFactory;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addIndexedEntity(Country.class).addProperty("directory.type", "local-heap");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @BeforeClass
    public void prepareSearchManager() {
        this.queryFactory = Search.getQueryFactory((Cache)this.cache);
    }

    @AfterMethod
    public void cleanupData() {
        this.cache.clear();
    }

    @Test
    public void searchOnEmptyIndex() {
        List list = this.getCountryQuery().list();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    private Query getCountryQuery() {
        String q = String.format("FROM %s where countryName:'Italy'", Country.class.getName());
        return this.queryFactory.create(q);
    }

    private Query getMatchAllQuery() {
        String q = String.format("FROM %s", Country.class.getName());
        return this.queryFactory.create(q);
    }

    @Test
    public void searchOnAllTypes() {
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.getCountryQuery().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        list = this.getCountryQuery().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        list = this.getMatchAllQuery().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void searchOnSimpleField() throws Exception {
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.getCountryQuery().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void searchOnEmbeddedField() {
        Country uk = new Country();
        City london = new City();
        london.name = "London";
        City newcastle = new City();
        newcastle.name = "Newcastle";
        uk.countryName = "United Kingdom";
        uk.cities.add(newcastle);
        uk.cities.add(london);
        this.cache.put((Object)"UK", (Object)uk);
        this.cache.put((Object)"UK", (Object)uk);
        this.cache.put((Object)"UK", (Object)uk);
        String q = String.format("FROM %s c where c.cities.name:'Newcastle'", Country.class.getName());
        List list = this.queryFactory.create(q).list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertSame((Object)uk, list.get(0));
    }
}

