/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.AbstractDelegatingRpcManager;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.IndexingDuringStateTransferTest")
public class IndexingDuringStateTransferTest
extends MultipleCacheManagersTest {
    private static final String KEY = "k";
    private static final Person RADIM = new Person("Radim", "Tough guy!", 29);
    private static final Person DAN = new Person("Dan", "Not that tough.", 39);
    private static final AnotherGrassEater FLUFFY = new AnotherGrassEater("Fluffy", "Very cute.");
    private ConfigurationBuilder builder;
    private final ControlledConsistentHashFactory.Default chf = new ControlledConsistentHashFactory.Default(0, new int[]{1});

    protected void createCacheManagers() throws Throwable {
        this.builder = IndexingDuringStateTransferTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.builder.clustering().hash().numSegments(1).numOwners(2).consistentHashFactory((ConsistentHashFactory)this.chf);
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, this.builder);
    }

    @BeforeMethod
    public void cleanData() {
        this.caches().forEach(Cache::clear);
    }

    public void testPut() {
        this.test(c -> c.put((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed);
    }

    public void testPutIgnoreReturnValue() {
        this.test(c -> c.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed);
    }

    public void testPutMap() {
        this.test(c -> c.putAll(Collections.singletonMap(KEY, FLUFFY)), this::assertFluffyIndexed);
    }

    public void testReplace() {
        this.test(c -> c.replace((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed);
    }

    @Test(enabled=false, description="ISPN-11299")
    public void testRemove() {
        this.test(c -> c.remove((Object)KEY), sm -> {});
    }

    public void testCompute() {
        this.test(c -> c.compute((Object)KEY, (SerializableBiFunction & Serializable)(k, old) -> FLUFFY), this::assertFluffyIndexed);
    }

    @Test(enabled=false, description="ISPN-7590")
    public void testComputeRemove() {
        this.test(c -> c.compute((Object)KEY, (SerializableBiFunction & Serializable)(k, old) -> null), sm -> {});
    }

    public void testMerge() {
        this.test(c -> c.merge((Object)KEY, (Object)FLUFFY, (SerializableBiFunction & Serializable)(o, n) -> n), this::assertFluffyIndexed);
    }

    @Test(enabled=false, description="ISPN-7590")
    public void testMergeRemove() {
        this.test(c -> c.merge((Object)KEY, (Object)FLUFFY, (SerializableBiFunction & Serializable)(o, n) -> null), sm -> {});
    }

    private void test(Consumer<Cache<Object, Object>> op, Consumer<Cache<Object, Object>> check) {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        AssertJUnit.assertEquals((int)0, (int)TestQueryHelperFactory.queryAll(cache0, Person.class).size());
        cache0.put((Object)KEY, (Object)RADIM);
        cache0.put((Object)"k2", (Object)DAN);
        StaticTestingErrorHandler.assertAllGood(cache0, cache1);
        List<Person> found = TestQueryHelperFactory.queryAll(cache0, Person.class);
        AssertJUnit.assertEquals(Arrays.asList(RADIM, DAN), this.sortByAge(found));
        this.chf.setOwnerIndexes(1, new int[]{2});
        this.addClusterEnabledCacheManager(QueryTestSCI.INSTANCE, this.builder).getCache();
        this.eventuallyEquals(null, () -> cache0.getAdvancedCache().getDataContainer().peek((Object)KEY));
        final AtomicReference exception = new AtomicReference();
        final CompletableFuture<Object> allowStateResponse = new CompletableFuture<Object>();
        this.caches().forEach(c -> TestingUtil.wrapComponent((Cache)c, RpcManager.class, original -> new AbstractDelegatingRpcManager((RpcManager)original){

            protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker, RpcOptions rpcOptions) {
                if (command instanceof StateResponseCommand) {
                    CompletableFuture stageWithTimeout = TestingUtil.orTimeout((CompletableFuture)allowStateResponse, (long)10L, (TimeUnit)TimeUnit.SECONDS, (Executor)IndexingDuringStateTransferTest.this.testExecutor());
                    return CompletionStages.handleAndCompose((CompletionStage)stageWithTimeout, (ignored, t) -> {
                        if (t != null) {
                            exception.set(t);
                        }
                        return super.performRequest(targets, command, collector, invoker, rpcOptions);
                    });
                }
                return super.performRequest(targets, command, collector, invoker, rpcOptions);
            }
        }));
        this.chf.setOwnerIndexes(0, new int[]{1});
        Future stoppingCacheFuture = this.fork(() -> this.killMember(2));
        TestingUtil.waitForTopologyPhase(Collections.emptyList(), (CacheTopology.Phase)CacheTopology.Phase.READ_OLD_WRITE_ALL, (Cache[])new Cache[]{this.cache(0)});
        AssertJUnit.assertNull((Object)cache0.getAdvancedCache().getDataContainer().peek((Object)KEY));
        op.accept((Cache<Object, Object>)cache0);
        allowStateResponse.complete(null);
        try {
            stoppingCacheFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AssertJUnit.assertNull(exception.get());
        StaticTestingErrorHandler.assertAllGood(cache0, this.cache(1));
        AssertJUnit.assertEquals(Collections.singletonList(DAN), TestQueryHelperFactory.queryAll(cache0, Person.class));
        Object value = this.cache(0).get((Object)KEY);
        AssertJUnit.assertFalse((String)("Current value: " + value), (boolean)(value instanceof Person));
        check.accept((Cache<Object, Object>)cache0);
    }

    private List<Person> sortByAge(List<Person> people) {
        people.sort(Comparator.comparingInt(Person::getAge));
        return people;
    }

    private void assertFluffyIndexed(Cache<Object, Object> cache) {
        AssertJUnit.assertEquals(Collections.singletonList(FLUFFY), TestQueryHelperFactory.queryAll(cache, AnotherGrassEater.class));
    }
}

