/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.impl.config.SearchPropertyExtractor;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.EngineConfigTest")
public class EngineConfigTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cacheManager;
    File tempDir;

    @BeforeMethod
    public void createTempDir() throws IOException {
        this.tempDir = Files.createTempDirectory(EngineConfigTest.class.getName(), new FileAttribute[0]).toFile();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        Util.recursiveFileRemove((File)this.tempDir);
    }

    @Test
    public void testPropertiesGeneration() {
        GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).storage(IndexStorage.FILESYSTEM).path(Paths.get(this.tempDir.getPath(), "baseDir").toString()).reader().refreshInterval(5000L).writer().commitInterval(2000).ramBufferSize(40).queueSize(555).queueCount(8).threadPoolSize(11).setLowLevelTrace(true).maxBufferedEntries(50000).merge().maxSize(1500).factor(30).calibrateByDeletes(true).minSize(100).maxForcedSize(110).maxEntries(12000);
        Map<String, Object> properties = this.resolveIndexingProperties(globalConfigurationBuilder, builder);
        AssertJUnit.assertEquals((Object)"local-filesystem", (Object)properties.get("hibernate.search.backend.directory.type"));
        AssertJUnit.assertEquals((Object)(this.tempDir.toString() + "/baseDir"), (Object)properties.get("hibernate.search.backend.directory.root"));
        AssertJUnit.assertEquals((Object)5000L, (Object)properties.get("hibernate.search.backend.io.refresh_interval"));
        AssertJUnit.assertEquals((Object)2000, (Object)properties.get("hibernate.search.backend.io.commit_interval"));
        AssertJUnit.assertEquals((Object)40, (Object)properties.get("hibernate.search.backend.io.writer.ram_buffer_size"));
        AssertJUnit.assertEquals((Object)555, (Object)properties.get("hibernate.search.backend.indexing.queue_size"));
        AssertJUnit.assertEquals((Object)8, (Object)properties.get("hibernate.search.backend.indexing.queue_count"));
        AssertJUnit.assertEquals((Object)11, (Object)properties.get("hibernate.search.backend.thread_pool.size"));
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)properties.get("hibernate.search.backend.io.writer.infostream"));
        AssertJUnit.assertEquals((Object)50000, (Object)properties.get("hibernate.search.backend.io.writer.max_buffered_docs"));
        AssertJUnit.assertEquals((Object)1500, (Object)properties.get("hibernate.search.backend.io.merge.max_size"));
        AssertJUnit.assertEquals((Object)30, (Object)properties.get("hibernate.search.backend.io.merge.factor"));
        AssertJUnit.assertEquals((Object)Boolean.TRUE, (Object)properties.get("hibernate.search.backend.io.merge.calibrate_by_deletes"));
        AssertJUnit.assertEquals((Object)100, (Object)properties.get("hibernate.search.backend.io.merge.min_size"));
        AssertJUnit.assertEquals((Object)110, (Object)properties.get("hibernate.search.backend.io.merge.max_forced_size"));
        AssertJUnit.assertEquals((Object)12000, (Object)properties.get("hibernate.search.backend.io.merge.max_docs"));
    }

    @Test
    public void testNoIndexLocationWithGlobalState() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.globalState().enabled(true).persistentLocation(this.tempDir.getPath());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).storage(IndexStorage.FILESYSTEM).create();
        Map<String, Object> properties = this.resolveIndexingProperties(gcb, builder);
        AssertJUnit.assertEquals((Object)this.tempDir.getPath(), (Object)properties.get("hibernate.search.backend.directory.root"));
    }

    @Test
    public void testNoIndexLocationWithoutGlobalState() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).enable();
        Map<String, Object> properties = this.resolveIndexingProperties(new GlobalConfigurationBuilder(), builder);
        AssertJUnit.assertEquals((Object)System.getProperty("user.dir"), (Object)properties.get("hibernate.search.backend.directory.root"));
    }

    @Test
    public void testLegacyIndexPathWithoutGlobalState() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).addProperty("default.indexBase", this.tempDir.getPath());
        Map<String, Object> properties = this.resolveIndexingProperties(new GlobalConfigurationBuilder(), builder);
        AssertJUnit.assertEquals((Object)this.tempDir.getPath(), (Object)properties.get("hibernate.search.backend.directory.root"));
    }

    @Test
    public void testRelativeIndexLocation() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.globalState().enabled(true).persistentLocation(this.tempDir.getPath());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity(Person.class).storage(IndexStorage.FILESYSTEM).path("my-index").create();
        Map<String, Object> properties = this.resolveIndexingProperties(gcb, builder);
        AssertJUnit.assertEquals((Object)(this.tempDir.getPath() + "/my-index"), (Object)properties.get("hibernate.search.backend.directory.root"));
    }

    private Map<String, Object> resolveIndexingProperties(GlobalConfigurationBuilder gcb, ConfigurationBuilder builder) {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (ConfigurationBuilder)builder);
        GlobalConfiguration globalConfiguration = this.cacheManager.getCacheManagerConfiguration();
        IndexingConfiguration indexingConfiguration = this.cacheManager.getCache().getCacheConfiguration().indexing();
        return SearchPropertyExtractor.extractProperties((GlobalConfiguration)globalConfiguration, (IndexingConfiguration)indexingConfiguration, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }
}

