/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.testdomain.hsearch;

import java.io.Serializable;
import java.util.Date;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.dsl.embedded.testdomain.Transaction;

@Indexed
public class TransactionHS
implements Transaction,
Serializable {
    private int id;
    private String description;
    private String longDescription;
    private String notes;
    private int accountId;
    private Date date;
    private double amount;
    private boolean isDebit;
    private boolean isValid;

    @Override
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    @ProtoField(number=1, defaultValue="0")
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    @ProtoField(number=2)
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Field
    @ProtoField(number=3)
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    @Field
    @Analyzer(definition="ngram")
    @ProtoField(number=4)
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    @Field(store=Store.YES, analyze=Analyze.NO)
    @ProtoField(number=5, defaultValue="0")
    public int getAccountId() {
        return this.accountId;
    }

    @Override
    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    @Override
    @Field(store=Store.YES, analyze=Analyze.NO)
    @ProtoField(number=6)
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    @Field(store=Store.YES, analyze=Analyze.NO)
    @SortableField
    @ProtoField(number=7, defaultValue="0")
    public double getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    @Field(store=Store.YES, analyze=Analyze.NO)
    @ProtoField(number=8, defaultValue="false")
    public boolean isDebit() {
        return this.isDebit;
    }

    @Override
    public void setDebit(boolean isDebit) {
        this.isDebit = isDebit;
    }

    @Override
    @ProtoField(number=9, defaultValue="false")
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionHS other = (TransactionHS)o;
        if (this.accountId != other.accountId) {
            return false;
        }
        if (Double.compare(other.amount, this.amount) != 0) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isDebit != other.isDebit) {
            return false;
        }
        if (this.isValid != other.isValid) {
            return false;
        }
        if (this.date != null ? !this.date.equals(other.date) : other.date != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(other.description) : other.description != null) {
            return false;
        }
        if (this.longDescription != null ? !this.longDescription.equals(other.longDescription) : other.longDescription != null) {
            return false;
        }
        return !(this.notes != null ? !this.notes.equals(other.notes) : other.notes != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.longDescription != null ? this.longDescription.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + this.accountId;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.amount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isDebit ? 1 : 0);
        result = 31 * result + (this.isValid ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TransactionHS{id=" + this.id + ", description='" + this.description + '\'' + ", longDescription='" + this.longDescription + '\'' + ", notes='" + this.notes + '\'' + ", accountId=" + this.accountId + ", date='" + this.date + '\'' + ", amount=" + this.amount + ", isDebit=" + this.isDebit + ", isValid=" + this.isValid + '}';
    }
}

